/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Object;
import java.io.InputStream;

public abstract class ASN1NonStringObject
extends ASN1Object {
    public boolean checkTag(int tag) throws ASN1Exception {
        return (tag & 0x1F) == this.getTag();
    }

    public boolean checkExplicitTag(int tag, int number) throws ASN1Exception {
        return tag == (0xA0 | number);
    }

    public boolean checkImplicitTag(int tag, int number) throws ASN1Exception {
        return tag == (0x80 | number);
    }

    public byte getExplicitTag(int number) throws ASN1Exception {
        return (byte)(0xA0 | number);
    }

    public byte getImplicitTag(int number) throws ASN1Exception {
        return (byte)(0x80 | number);
    }

    public void decodeValueIndefiniteLength(int tag, InputStream in) throws ASN1Exception {
        throw new ASN1Exception("Indefinite length is invalid for primitive objects");
    }
}

