/*
 * Decompiled with CFR 0.152.
 */
package nl.ow.dilemma.ant.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class UnsignJarImpl {
    public void unsign(File jarfile) throws IOException {
        if (!jarfile.canRead()) {
            System.err.println("Cannot read file " + jarfile.getAbsolutePath());
            return;
        }
        if (!jarfile.canWrite()) {
            System.err.println("Cannot write file " + jarfile.getAbsolutePath());
            return;
        }
        File tmpFile = null;
        try {
            tmpFile = new File(jarfile.getParent(), "unsigner_" + UUID.randomUUID().toString() + ".tmp");
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(jarfile));
            this.unsign(bis, bos);
            bos.close();
            bis.close();
            jarfile.delete();
            tmpFile.renameTo(jarfile);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public void unsign(InputStream is, OutputStream os) throws IOException {
        JarEntry src;
        JarInputStream jis = new JarInputStream(is);
        JarOutputStream jos = null;
        Manifest manifest = jis.getManifest();
        if (manifest == null) {
            jos = new JarOutputStream(os);
        } else {
            manifest.getEntries().clear();
            jos = new JarOutputStream(os, manifest);
        }
        while ((src = jis.getNextJarEntry()) != null) {
            String name = src.getName();
            String lowercaseName = name.toLowerCase();
            if (lowercaseName.startsWith("meta-inf") && (lowercaseName.endsWith(".rsa") || lowercaseName.endsWith(".dsa") || lowercaseName.endsWith(".sf"))) continue;
            JarEntry dest = new JarEntry(name);
            jos.putNextEntry(dest);
            UnsignJarImpl.copyContent(jis, jos);
        }
        jos.close();
        jis.close();
    }

    private static void copyContent(JarInputStream jis, JarOutputStream jos) throws IOException {
        byte[] buffer = new byte[4096];
        int len = 0;
        while ((len = jis.read(buffer)) != -1) {
            jos.write(buffer, 0, len);
        }
    }
}

