/*
 * Decompiled with CFR 0.152.
 */
package nl.ow.dilemma.ant.fetch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Available;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Get;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FlatFileNameMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchTask
extends Task {
    private URL downloadUrl;
    private File destination;
    private String className;
    private Path classpath;
    private List<PatternSet> patternSets = new ArrayList<PatternSet>();
    private boolean useCache = false;
    private int maxtime = 0;
    private boolean failonerror = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.className != null) {
            Available av = new Available();
            av.setClassname(this.className);
            av.setProject(this.getProject());
            av.setClasspath(this.classpath);
            if (av.eval()) {
                this.log("Class " + this.className + " is already present, skipping download.");
                return;
            }
        }
        File tmpFile = null;
        String filename = this.getFile(this.downloadUrl);
        try {
            File localFile = this.getCachedFile(filename);
            if (localFile != null && this.useCache) {
                if (this.patternSets.size() > 0) {
                    this.unzipToDirectory(localFile, this.destination, this.patternSets);
                } else {
                    this.log("Copy file from cache: " + localFile.getCanonicalPath());
                    this.copyFileToDirectory(localFile, null, this.destination);
                }
            } else {
                tmpFile = File.createTempFile("FetchTask", "tmp");
                this.getFromUrl(this.downloadUrl, tmpFile);
                if (this.useCache) {
                    File fetchDir = this.getFetchDir();
                    this.log("Write file " + filename + " to cache " + fetchDir);
                    this.copyFileToDirectory(tmpFile, filename, fetchDir);
                }
                if (this.patternSets.size() > 0) {
                    this.unzipToDirectory(tmpFile, this.destination, this.patternSets);
                } else {
                    File destFile = new File(this.destination, filename);
                    this.log("Moving to " + destFile.getAbsolutePath());
                    boolean success = tmpFile.renameTo(destFile);
                    if (!success) {
                        this.copyFileToDirectory(tmpFile, filename, destFile.getParentFile());
                        success = tmpFile.delete();
                        if (!success) {
                            this.log("Could not remove " + tmpFile.getCanonicalPath());
                            tmpFile.deleteOnExit();
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            if (this.failonerror) {
                throw new BuildException((Throwable)ex);
            }
            this.log(ex.getMessage());
        }
        finally {
            if (tmpFile != null && this.patternSets.size() > 0) {
                tmpFile.delete();
            }
        }
    }

    private void getFromUrl(URL url, File tmp) throws BuildException {
        try {
            Get getTask = new Get();
            getTask.setProject(this.getProject());
            getTask.setSrc(url);
            getTask.setDest(tmp);
            getTask.setVerbose(true);
            getTask.setRetries(5);
            getTask.setMaxTime((long)this.maxtime);
            getTask.setTaskName(this.getTaskName());
            getTask.execute();
        }
        catch (Throwable ex) {
            throw new BuildException(ex);
        }
    }

    private void unzipToDirectory(File zipFile, File unzipDirectory, List<PatternSet> allPatternSets) throws BuildException {
        if (unzipDirectory.exists() && !unzipDirectory.isDirectory()) {
            throw new BuildException(unzipDirectory.getAbsolutePath() + "already exists and is not an directory.");
        }
        if (!unzipDirectory.exists()) {
            this.log("Creating " + this.getCanonicalPath(unzipDirectory));
            unzipDirectory.mkdirs();
        }
        Expand expandTask = new Expand();
        expandTask.setProject(this.getProject());
        expandTask.setSrc(zipFile);
        expandTask.setDest(this.getCanonicalFile(unzipDirectory));
        expandTask.setTaskName(this.getTaskName());
        for (PatternSet patternSet : allPatternSets) {
            expandTask.addPatternset(patternSet);
        }
        Mapper mapper = expandTask.createMapper();
        mapper.add((FileNameMapper)new FlatFileNameMapper());
        expandTask.execute();
    }

    public void setUrl(URL url) {
        this.downloadUrl = url;
    }

    public void setDest(File dest) {
        this.destination = dest;
    }

    public void addPatternset(PatternSet set) {
        this.patternSets.add(set);
    }

    public void setClassname(String name) {
        this.className = name;
    }

    private String getCanonicalPath(File in) {
        try {
            return in.getCanonicalPath();
        }
        catch (IOException ex) {
            return in.getAbsolutePath();
        }
    }

    private File getCanonicalFile(File in) {
        try {
            return in.getCanonicalFile();
        }
        catch (IOException ex) {
            return in.getAbsoluteFile();
        }
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public boolean getUsecache() {
        return this.useCache;
    }

    public void setUsecache(boolean use) {
        this.useCache = use;
    }

    public void setMaxtime(int maxtime) {
        this.maxtime = maxtime;
    }

    public int getMaxtime() {
        return this.maxtime;
    }

    public boolean isFailonerror() {
        return this.failonerror;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    private String getFile(URL url) {
        String path = url.getPath();
        if (path.contains("/")) {
            int position = path.lastIndexOf("/");
            return path.substring(position + 1);
        }
        return path;
    }

    private File getCachedFile(String fileName) {
        File fetchDir = this.getFetchDir();
        File file = new File(fetchDir, fileName);
        if (!file.exists()) {
            return null;
        }
        if (!file.canRead()) {
            throw new BuildException(fetchDir.getAbsolutePath() + " is not readable");
        }
        return file;
    }

    private File getFetchDir() {
        File homedir = new File(System.getProperty("user.home"));
        File fetchDir = new File(homedir, ".fetch");
        if (fetchDir.exists()) {
            if (!fetchDir.isDirectory()) {
                throw new BuildException(fetchDir.getAbsolutePath() + " is not a directory");
            }
            if (!fetchDir.canWrite()) {
                throw new BuildException(fetchDir.getAbsolutePath() + " is not writable");
            }
        } else {
            this.log("Creating fetch local cache directory " + fetchDir.getAbsolutePath());
            fetchDir.mkdirs();
        }
        return fetchDir;
    }

    private void copyFileToDirectory(File src, String name, File directory) {
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            if (name == null) {
                name = src.getName();
            }
            File toFile = new File(directory, name);
            in = new FileInputStream(src);
            out = new FileOutputStream(toFile);
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.flush();
            out.close();
        }
        catch (Throwable ex) {
            throw new BuildException(ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

