/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.event.InstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.SpecHelper;
import java.io.File;
import java.util.ArrayList;

public class SimpleInstallerListener
implements InstallerListener {
    private static ArrayList<SimpleInstallerListener> progressBarCaller = new ArrayList();
    protected static final String LANG_FILE_NAME = "CustomActionsLang.xml";
    protected static LocaleDatabase langpack = null;
    protected static boolean doInformProgressBar = false;
    private AutomatedInstallData installdata = null;
    private SpecHelper specHelper = null;

    public SimpleInstallerListener() {
        this(false);
    }

    public SimpleInstallerListener(boolean useSpecHelper) {
        if (useSpecHelper) {
            this.setSpecHelper(new SpecHelper());
        }
    }

    public void afterFile(File file, PackFile pf) throws Exception {
    }

    public void afterDir(File dir, PackFile pf) throws Exception {
    }

    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
    }

    public void afterPack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
    }

    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        if (this.installdata == null) {
            this.installdata = idata;
        }
        if (this.installdata != null && langpack == null) {
            try {
                String resource = "CustomActionsLang.xml_" + this.installdata.localeISO3;
                langpack = new LocaleDatabase(ResourceManager.getInstance().getInputStream(resource));
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
    }

    public void beforePack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
    }

    public boolean isFileListener() {
        return false;
    }

    public void beforeFile(File file, PackFile pf) throws Exception {
    }

    public void beforeDir(File dir, PackFile pf) throws Exception {
    }

    public void afterInstallerInitialization(AutomatedInstallData data) {
        this.installdata = data;
    }

    public SpecHelper getSpecHelper() {
        return this.specHelper;
    }

    public void setSpecHelper(SpecHelper helper) {
        this.specHelper = helper;
    }

    public AutomatedInstallData getInstalldata() {
        return this.installdata;
    }

    public void setInstalldata(AutomatedInstallData data) {
        this.installdata = data;
    }

    public static int getProgressBarCallerCount() {
        return progressBarCaller.size();
    }

    protected int getProgressBarCallerId() {
        for (int i = 0; i < progressBarCaller.size(); ++i) {
            if (progressBarCaller.get(i) != this) continue;
            return i + 1;
        }
        return 0;
    }

    protected void setProgressBarCaller() {
        progressBarCaller.add(this);
    }

    protected boolean informProgressBar() {
        return doInformProgressBar;
    }

    protected String getMsg(String id) {
        String retval = id;
        if (langpack != null) {
            retval = langpack.getString(id);
        }
        if (retval.equals(id) && this.getInstalldata() != null) {
            retval = this.getInstalldata().langpack.getString(id);
        }
        return retval;
    }
}

