/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.views.list;

import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarView;
import bizcal.util.DateUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import lu.tudor.santec.bizcal.views.ListViewPanel;
import lu.tudor.santec.bizcal.views.list.ListModel;
import lu.tudor.santec.bizcal.views.list.ListRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListView
extends CalendarView
implements MouseListener {
    private JPanel panel;
    private JTable table;
    private ListModel listModel;
    private boolean showDeparted = false;
    private int showDays = 7;
    private ListViewPanel parent;
    private Date date;
    private List<Event> showEvents = new ArrayList<Event>();

    public ListView(CalendarViewConfig desc, ListViewPanel parent) throws Exception {
        super(desc);
        this.parent = parent;
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setLayout(new BorderLayout());
        this.listModel = new ListModel();
        this.table = new JTable(this.listModel);
        ListRenderer renderer = new ListRenderer(this.listModel);
        this.table.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.table.getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.table.getColumnModel().getColumn(2).setCellRenderer(renderer);
        this.table.getColumnModel().getColumn(3).setCellRenderer(renderer);
        this.table.getColumnModel().getColumn(0).setMinWidth(120);
        this.table.getColumnModel().getColumn(0).setMaxWidth(120);
        this.table.getColumnModel().getColumn(1).setMinWidth(30);
        this.table.getColumnModel().getColumn(1).setMaxWidth(30);
        this.table.getColumnModel().getColumn(2).setMinWidth(120);
        this.table.getColumnModel().getColumn(2).setMaxWidth(120);
        this.table.setRowHeight(32);
        this.table.addMouseListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        JScrollPane jsp = new JScrollPane(this.table);
        jsp.setOpaque(false);
        jsp.getViewport().setOpaque(false);
        this.panel.add((Component)jsp, "Center");
        this.setDate(new Date());
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    protected Date getDate(int xPos, int yPos) throws Exception {
        return null;
    }

    @Override
    public void refresh0() throws Exception {
        if (this.broker != null) {
            List<Event> events = this.broker.getEvents(null);
            if (!this.showDeparted) {
                Date start = this.date;
                Date end = DateUtil.getDiffDay(start, this.showDays);
                this.parent.setTitle(start, end);
                this.showEvents.clear();
                for (Event ev : events) {
                    if (!ev.getStart().after(start) || !ev.getStart().before(end)) continue;
                    this.showEvents.add(ev);
                }
            } else {
                this.showEvents = events;
            }
            this.listModel.setEvents(this.showEvents);
        }
    }

    public boolean isShowDeparted() {
        return this.showDeparted;
    }

    public void setShowDeparted(boolean showDeparted) {
        this.showDeparted = showDeparted;
        try {
            this.refresh0();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getShowDays() {
        return this.showDays;
    }

    public void setShowDays(int showDays) {
        this.showDays = showDays;
        try {
            this.refresh0();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDate(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this.date = c.getTime();
        try {
            this.refresh0();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            this.listener.eventDoubleClick(null, this.listModel.getEvent(this.table.getSelectedRow()), e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public List<Event> getEvents() {
        return this.showEvents;
    }
}

