/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.views.list;

import bizcal.common.Event;
import bizcal.util.DateUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import lu.tudor.santec.bizcal.views.list.ListModel;

public class ListRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private ListModel model;
    private Border newDayBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK);
    private Border border;

    public ListRenderer(ListModel listModel) {
        this.model = listModel;
        this.setFont(new Font("Arial", 0, 12));
    }

    public Component getTableCellRendererComponent(JTable p_Table, Object value, boolean p_IsSelected, boolean hasFocus, int p_Row, int p_Column) {
        Event e = this.model.getEvent(p_Row);
        Color c = Color.WHITE;
        try {
            c = e.getColor();
            c = new Date().before(e.getEnd()) ? new Color(c.getRed(), c.getGreen(), c.getBlue(), 120) : new Color(c.getRed(), c.getGreen(), c.getBlue(), 20);
            this.border = !DateUtil.isSameDay(e.getStart(), this.model.getEvent(p_Row - 1).getStart()) ? this.newDayBorder : null;
        }
        catch (Exception ee) {
            this.border = null;
        }
        switch (p_Column) {
            case 0: {
                this.setVerticalAlignment(1);
                this.setHorizontalAlignment(2);
                this.setText((String)value);
                this.setIcon(null);
                break;
            }
            case 1: {
                this.setVerticalAlignment(0);
                this.setHorizontalAlignment(0);
                this.setText(null);
                this.setIcon((ImageIcon)value);
                break;
            }
            default: {
                this.setVerticalAlignment(1);
                this.setHorizontalAlignment(2);
                this.setText((String)value);
                this.setIcon(null);
                if (p_Table.getRowHeight(p_Row) >= this.getPreferredSize().height) break;
                p_Table.setRowHeight(p_Row, this.getPreferredSize().height + 4);
            }
        }
        if (p_IsSelected) {
            this.setBackground(p_Table.getSelectionBackground());
        } else {
            this.setBackground(c);
        }
        this.setBorder(this.border);
        return this;
    }
}

