/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.export;

import bizcal.common.Event;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.UidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICALExporter {
    private Calendar calendar = new Calendar();
    private UidGenerator uidGenerator;
    private boolean showCalendarName = true;
    private static Logger logger = Logger.getLogger(ICALExporter.class.getName());

    public ICALExporter() {
        this.calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        this.calendar.getProperties().add((Property)Version.VERSION_2_0);
        this.calendar.getProperties().add((Property)CalScale.GREGORIAN);
        try {
            this.uidGenerator = new UidGenerator("1");
        }
        catch (SocketException e) {
            logger.log(Level.WARNING, "uidGenerator failed", e);
        }
    }

    public void saveEvents(Collection<Event> events) {
        for (Event event : events) {
            String summary = "";
            if (this.showCalendarName && event.get("calendar_name") != null) {
                summary = String.valueOf(summary) + event.get("calendar_name") + ": " + "\n";
            }
            summary = String.valueOf(summary) + event.getSummary();
            VEvent vev = new VEvent((Date)new DateTime(event.getStart()), (Date)new DateTime(event.getEnd()), summary);
            Description d = new Description(event.getDescription());
            vev.getProperties().add((Property)d);
            Location l = new Location((String)event.get("calendar_name"));
            vev.getProperties().add((Property)l);
            vev.getProperties().add((Property)this.uidGenerator.generateUid());
            this.calendar.getComponents().add((Component)vev);
        }
    }

    public void writeICSFile(File f) {
        try {
            FileOutputStream fout = new FileOutputStream(f);
            CalendarOutputter outputter = new CalendarOutputter();
            outputter.output(this.calendar, (OutputStream)fout);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "writing ICS file failed", e);
        }
    }

    public boolean isShowCalendarName() {
        return this.showCalendarName;
    }

    public void setShowCalendarName(boolean showCalendarName) {
        this.showCalendarName = showCalendarName;
    }
}

