/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal;

import bizcal.common.Event;
import java.awt.Color;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import lu.tudor.santec.bizcal.widgets.CheckBoxPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NamedCalendar {
    public static final String CALENDAR_NAME = "calendar_name";
    private String name;
    private String description;
    private Color color;
    private boolean showing;
    private boolean selected;
    private Integer id;
    private Boolean isBackground;
    private CheckBoxPanel checkBox;
    private Border border = BorderFactory.createLineBorder(Color.BLACK, 2);

    public NamedCalendar(String name) {
        this.name = name;
        this.isBackground = false;
    }

    public NamedCalendar(String name, String description) {
        this.name = name;
        this.description = description;
        this.isBackground = false;
    }

    public NamedCalendar(String name, String description, Color color) {
        this.name = name;
        this.description = description;
        this.color = color;
        this.isBackground = false;
    }

    public NamedCalendar(String name, Boolean isBackground) {
        this.name = name;
        this.isBackground = isBackground;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.checkBox != null) {
            this.checkBox.setColor(color);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return this.showing;
    }

    public void setActive(boolean showing) {
        this.showing = showing;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " (" + this.getDescription() + ") " + this.isActive();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public CheckBoxPanel getCheckBox() {
        return this.checkBox;
    }

    public void setCheckBox(CheckBoxPanel checkBox) {
        this.checkBox = checkBox;
    }

    public void setBackground(Boolean isBackground) {
        this.isBackground = isBackground;
    }

    public Boolean isBackground() {
        return this.isBackground;
    }

    public void setBorder(Color color, int thickness) {
        this.border = BorderFactory.createLineBorder(color, thickness);
        this.getCheckBox().setBorder(this.border);
    }

    public void addBorder() {
        this.getCheckBox().setBorder(this.border);
    }

    public void removeBorder() {
        this.getCheckBox().setBorder(null);
    }

    public abstract List<Event> addEvent(String var1, Event var2);

    public abstract void deleteEvent(String var1, Event var2);

    public abstract List<Event> getEvents(Date var1, Date var2);

    public abstract List<Event> saveEvent(String var1, Event var2, boolean var3);
}

