/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal;

import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.DayView;
import bizcal.swing.util.FrameArea;
import bizcal.util.DateInterval;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import lu.tudor.santec.bizcal.CalendarIcons;
import lu.tudor.santec.bizcal.CalendarPanel;
import lu.tudor.santec.bizcal.EventModel;
import lu.tudor.santec.bizcal.NamedCalendar;
import lu.tudor.santec.bizcal.listeners.NamedCalendarListener;
import lu.tudor.santec.bizcal.util.ObservableEventList;
import lu.tudor.santec.bizcal.views.DayViewPanel;
import lu.tudor.santec.bizcal.views.ListViewPanel;
import lu.tudor.santec.bizcal.views.MonthViewPanel;

public class CalendarDemo
extends JFrame {
    private static final long serialVersionUID = 1L;
    private ObservableEventList eventDataList;
    private DayViewPanel dayViewPanel;
    private DayViewPanel weekViewPanel;
    private MonthViewPanel monthViewPanel;
    private ListViewPanel listViewPanel;
    private CalendarPanel calendarPanel = new CalendarPanel();
    private DayViewPanel dayThreeViewPanel;

    public CalendarDemo() {
        super("Calendar Demo");
        this.eventDataList = new ObservableEventList();
        EventModel dayModel = new EventModel(this.eventDataList, 1);
        EventModel weekModel = new EventModel(this.eventDataList, 2);
        EventModel monthModel = new EventModel(this.eventDataList, 3);
        EventModel listModel = new EventModel(this.eventDataList, 3);
        EventModel dayThreeModel = new EventModel(this.eventDataList, 4);
        this.dayViewPanel = new DayViewPanel(dayModel, 1);
        this.dayThreeViewPanel = new DayViewPanel(dayThreeModel, 1);
        this.weekViewPanel = new DayViewPanel(weekModel, 1);
        this.monthViewPanel = new MonthViewPanel(monthModel);
        this.listViewPanel = new ListViewPanel(listModel);
        DemoCalendarListener calListener = new DemoCalendarListener();
        this.dayViewPanel.addCalendarListener(calListener);
        this.dayThreeViewPanel.addCalendarListener(calListener);
        this.weekViewPanel.addCalendarListener(calListener);
        this.monthViewPanel.addCalendarListener(calListener);
        this.listViewPanel.addCalendarListener(calListener);
        this.calendarPanel.addCalendarView(this.dayViewPanel);
        this.calendarPanel.addCalendarView(this.dayThreeViewPanel);
        this.calendarPanel.addCalendarView(this.weekViewPanel);
        this.calendarPanel.addCalendarView(this.monthViewPanel);
        this.calendarPanel.addCalendarView(this.listViewPanel);
        this.calendarPanel.addNamedCalendar(new TestNamedCalendar("Peter", "dem Peter seiner", Color.RED));
        this.calendarPanel.addNamedCalendar(new TestNamedCalendar("Max", "dem Max seiner", Color.BLUE));
        this.calendarPanel.addNamedCalendar(new TestNamedCalendar("Office", "allen ihrer", Color.GRAY));
        this.calendarPanel.addNamedCalendarListener(new NamedCalendarListener(){

            @Override
            public void activeCalendarsChanged(Collection<NamedCalendar> calendars) {
                if (calendars == null || calendars.size() < 1) {
                    CalendarDemo.this.eventDataList.clear();
                    return;
                }
                CalendarDemo.this.updateEventsForActiveCalendars();
            }

            @Override
            public void selectedCalendarChanged(NamedCalendar selectedCalendar) {
                CalendarDemo.this.updateEventsForActiveCalendars();
            }
        });
        AbstractAction layout0Action = new AbstractAction("0", CalendarIcons.getMediumIcon(CalendarIcons.CHANGE_LAYOUT_MODE)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                System.out.println("### layout mode 0 ###");
                DayView currentDayView = (DayView)CalendarDemo.this.calendarPanel.getCurrentView().getView();
                currentDayView.setLayoutMode(0);
                try {
                    currentDayView.refresh0();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        };
        this.calendarPanel.getFunctionsButtonPanel().addAction(layout0Action);
        AbstractAction layout1Action = new AbstractAction("1", CalendarIcons.getMediumIcon(CalendarIcons.CHANGE_LAYOUT_MODE)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                System.out.println("### layout mode 1 ###");
                DayView currentDayView = (DayView)CalendarDemo.this.calendarPanel.getCurrentView().getView();
                currentDayView.setLayoutMode(1);
                try {
                    currentDayView.refresh0();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        };
        this.calendarPanel.getFunctionsButtonPanel().addAction(layout1Action);
        AbstractAction layout2Action = new AbstractAction("2", CalendarIcons.getMediumIcon(CalendarIcons.CHANGE_LAYOUT_MODE)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                DayView currentDayView = (DayView)CalendarDemo.this.calendarPanel.getCurrentView().getView();
                System.out.println("### layout mode 2 ###");
                currentDayView.setLayoutMode(2);
                try {
                    currentDayView.refresh0();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        };
        this.calendarPanel.getFunctionsButtonPanel().addAction(layout2Action);
        this.add(this.calendarPanel);
        this.setDefaultCloseOperation(3);
        this.setSize(1000, 700);
        this.setVisible(true);
    }

    private synchronized void updateEventsForActiveCalendars() {
        ArrayList<Event> allActiveEvents = new ArrayList<Event>();
        for (NamedCalendar nc : this.calendarPanel.getCalendars()) {
            if (!nc.isActive() && !nc.isSelected()) continue;
            allActiveEvents.addAll(nc.getEvents(null, null));
        }
        Collections.sort(allActiveEvents);
        this.eventDataList.clear();
        this.eventDataList.addAll((Collection<? extends Event>)allActiveEvents);
    }

    public static void main(String[] args) {
        new CalendarDemo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DemoCalendarListener
    implements CalendarListener {
        DemoCalendarListener() {
        }

        @Override
        public void closeCalendar(Object calId) throws Exception {
        }

        @Override
        public void copy(List<Event> list) throws Exception {
        }

        @Override
        public void dateChanged(Date date) throws Exception {
        }

        @Override
        public void dateSelected(Date date) throws Exception {
        }

        @Override
        public void deleteEvent(Event event) throws Exception {
            CalendarDemo.this.eventDataList.remove(event);
        }

        @Override
        public void deleteEvents(List<Event> events) {
            CalendarDemo.this.eventDataList.removeAll(events);
        }

        @Override
        public void eventClicked(Object id, Event _event, FrameArea area, MouseEvent e) {
        }

        @Override
        public void eventDoubleClick(Object id, Event event, MouseEvent mouseEvent) {
        }

        @Override
        public void eventSelected(Object id, Event event) throws Exception {
            if (CalendarDemo.this.calendarPanel.getCalendars() == null) {
                return;
            }
            for (NamedCalendar cal : CalendarDemo.this.calendarPanel.getCalendars()) {
                cal.setSelected(false);
                cal.removeBorder();
                if (!cal.getId().equals(event.get("calendarId"))) continue;
                CalendarDemo.this.calendarPanel.setSelectedCalendar(cal);
                cal.setSelected(true);
                cal.addBorder();
            }
        }

        @Override
        public void eventsSelected(List<Event> list) throws Exception {
        }

        @Override
        public void moved(Event event, Object orgCalId, Date orgDate, Object newCalId, Date newDate) throws Exception {
            event.move(newDate);
            CalendarDemo.this.eventDataList.trigger();
        }

        @Override
        public void newCalendar() throws Exception {
        }

        @Override
        public void newEvent(Object id, Date date) throws Exception {
            DateInterval interval = new DateInterval(date, new Date(date.getTime() + 900000L));
            this.newEvent(id, interval);
        }

        @Override
        public void newEvent(Object id, DateInterval interval) throws Exception {
            NamedCalendar nc = CalendarDemo.this.calendarPanel.getSelectedCalendar();
            if (nc == null) {
                return;
            }
            Event event = new Event();
            event.setStart(interval.getStartDate());
            event.setEnd(interval.getEndDate());
            event.setId(id);
            nc.addEvent("clientXXX", event);
        }

        @Override
        public void paste(Object calId, Date date) throws Exception {
        }

        @Override
        public void resized(Event event, Object orgCalId, Date orgEndDate, Date newEndDate) throws Exception {
            NamedCalendar nc = CalendarDemo.this.calendarPanel.getSelectedCalendar();
            if (nc == null) {
                return;
            }
            event.setEnd(newEndDate);
            nc.saveEvent("clientXXX", event, false);
        }

        @Override
        public void selectionReset() throws Exception {
        }

        @Override
        public void showEvent(Object id, Event event) throws Exception {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestNamedCalendar
    extends NamedCalendar {
        private List<Event> calendarEvents;

        public TestNamedCalendar(String name, String description, Color color) {
            super(name, description, color);
            this.calendarEvents = new ArrayList<Event>();
            this.setId(this.hashCode());
        }

        @Override
        public List<Event> getEvents(Date from, Date to) {
            return this.calendarEvents;
        }

        @Override
        public void deleteEvent(String clientId, Event event) {
            this.calendarEvents.remove(event);
            CalendarDemo.this.eventDataList.remove(event);
        }

        @Override
        public List<Event> addEvent(String clientId, Event event) {
            event.set("calendarId", this.getId());
            event.set("calendarIsBackground", this.isBackground());
            event.setColor(this.getColor());
            CalendarDemo.this.eventDataList.add(event);
            this.calendarEvents.add(event);
            return null;
        }

        @Override
        public List<Event> saveEvent(String clientId, Event event, boolean userInteraction) {
            return null;
        }
    }
}

