/*
 * Decompiled with CFR 0.152.
 */
package bizcal.util;

import bizcal.util.BizcalException;
import bizcal.util.LocaleBroker;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocalizedText {
    private String _bundleBaseName;
    private String _text;
    private LocalizedText fallback;
    private String defaultValue;

    public LocalizedText(String text, String bundleBaseName) {
        this._text = text;
        this._bundleBaseName = bundleBaseName;
        this.defaultValue = text;
    }

    public LocalizedText(String text) {
        this(text, null);
    }

    public String toString() {
        try {
            if (this._bundleBaseName == null) {
                return this._text;
            }
            ResourceBundle bundle = ResourceBundle.getBundle(this._bundleBaseName, LocaleBroker.getLocale());
            try {
                return bundle.getString(this._text);
            }
            catch (MissingResourceException mre) {
                if (this.fallback != null) {
                    return this.fallback.toString();
                }
                return this.defaultValue;
            }
        }
        catch (Exception e) {
            throw BizcalException.create(e);
        }
    }

    public String getKey() {
        return this._text;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setFallback(LocalizedText fallback) {
        this.fallback = fallback;
    }

    public static class Factory {
        private String _bundleBaseName;

        public Factory(String bundleBaseName) {
            this._bundleBaseName = bundleBaseName;
        }

        public LocalizedText createText(String text) {
            return new LocalizedText(text, this._bundleBaseName);
        }
    }
}

