/*
 * Decompiled with CFR 0.152.
 */
package bizcal.util;

import bizcal.util.DateUtil;
import bizcal.util.Interval;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateInterval
extends Interval {
    private static final long serialVersionUID = 1L;
    private long _duration;

    public DateInterval(Interval interval) throws Exception {
        this.setStart(interval.getStart());
        this.setEndDate((Date)interval.getEnd());
        this.setIncludeStart(interval.isIncludeStart());
        this.setIncludeEnd(interval.isIncludeEnd());
    }

    public DateInterval() {
    }

    public DateInterval(Date start, Date end) throws Exception {
        this.setStartDate(start);
        this.setEndDate(end);
    }

    public DateInterval(Date day) throws Exception {
        Date start = DateUtil.round2Day(day);
        this.setStartDate(start);
        Date end = DateUtil.getDiffDay(start, 1);
        this.setEndDate(end);
    }

    public DateInterval(Date day, int type) throws Exception {
        this.setStartDate(day);
        Calendar cal = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        cal.setTime(day);
        cal.add(type, 1);
        this.setEndDate(cal.getTime());
    }

    public DateInterval(Date day, int type, int count) throws Exception {
        this.setStartDate(day);
        Calendar cal = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        cal.setTime(day);
        cal.add(type, count);
        this.setEndDate(cal.getTime());
    }

    public DateInterval(Date start, long duration) throws Exception {
        this(start, new Date(start.getTime() + duration));
    }

    public Date getStartDate() throws Exception {
        return (Date)this.getStart();
    }

    public void setStartDate(Date start) throws Exception {
        this.setStart(start);
    }

    public Date getEndDate() throws Exception {
        return (Date)this.getEnd();
    }

    public void setEndDate(Date end) throws Exception {
        this.setEnd(end);
        if (this.getStartDate() == null) {
            return;
        }
        if (end == null) {
            return;
        }
        long diff = end.getTime() - this.getStartDate().getTime();
        long dstOffset = Math.abs(DateUtil.getDaylightSavingOffset(end)) - Math.abs(DateUtil.getDaylightSavingOffset(this.getStartDate()));
        this._duration = (long)((int)diff) + dstOffset;
    }

    public void setDuration(long duration) throws Exception {
        this._duration = duration;
        this.setEnd(new Date(this.getStartDate().getTime() + duration));
    }

    public long getDuration() {
        return this._duration;
    }

    public DateInterval intersection(DateInterval interval) throws Exception {
        Interval result = this.intersection((Interval)interval);
        return new DateInterval((Date)result.getStart(), (Date)result.getEnd());
    }

    public boolean isDayIn(Date date) {
        try {
            return this.getStartDate().before(date) && this.getEndDate().after(date);
        }
        catch (Exception e) {
            return false;
        }
    }
}

