/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class LassoArea
extends JComponent {
    private static final long serialVersionUID = 1L;
    private Color lineColor = Color.BLACK;
    private boolean dashed = true;
    private boolean roundedRectangle = false;

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage buffImg = new BufferedImage(width, height, 2);
        Graphics2D gbi = buffImg.createGraphics();
        gbi.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float[] dash1 = new float[]{5.0f};
        BasicStroke stroke = this.dashed ? new BasicStroke(1.0f, 0, 2, 10.0f, dash1, 0.0f) : new BasicStroke(1.0f);
        gbi.setStroke(stroke);
        if (this.roundedRectangle) {
            AlphaComposite ac = AlphaComposite.getInstance(4, 1.0f);
            gbi.setComposite(ac);
            gbi.setPaint(this.lineColor);
            gbi.draw(new RoundRectangle2D.Double(1.0, 1.0, width - 2, height - 2, 17.0, 17.0));
        } else {
            AlphaComposite ac = AlphaComposite.getInstance(4, 1.0f);
            gbi.setComposite(ac);
            gbi.setPaint(this.lineColor);
            gbi.draw(new Rectangle2D.Double(1.0, 1.0, width - 2, height - 2));
        }
        g2.drawImage(buffImg, null, 0, 0);
        super.paint(g2);
        super.paint(gbi);
    }

    public void setRoundedRectangle(boolean rounded) {
        this.roundedRectangle = rounded;
    }

    public boolean isRoundedRectangle() {
        return this.roundedRectangle;
    }

    public void setDashed(boolean rounded) {
        this.dashed = rounded;
    }

    public boolean isDashed() {
        return this.dashed;
    }

    public void setLineColor(Color aColor) {
        this.lineColor = aColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }
}

