/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class GradientArea
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final String TOP_BOTTOM = "TOP_BOTTOM";
    public static final String BOTTOM_TOP = "BOTTOM_TOP";
    public static final String LEFT_RIGHT = "LEFT_RIGHT";
    public static final String RIGHT_LEFT = "RIGHT_LEFT";
    public static final String TOPLEFT_BOTTOMRIGHT = "TOPLEFT_BOTTOMRIGHT";
    public static final String IN_OUT = "IN_OUT";
    public static final String BORDER_RECTANGLE = "BORDER_RECTANGLE";
    public static final String BORDER_TOP = "BORDER_TOP";
    private String itsFadeDirection;
    private double itsGradientLength;
    private Color itsStartColor;
    private Color itsEndColor;
    private float itsBorderWidth;
    private Color itsBorderColor;
    private boolean itsBorder;
    private String itsBorderType;
    private JLabel _label;

    public GradientArea() {
        this(TOP_BOTTOM, new Color(255, 255, 255), new Color(245, 245, 245));
    }

    public GradientArea(String aFadeDirection, Color aStartColor, Color aEndColor) {
        this.itsFadeDirection = aFadeDirection;
        this.itsStartColor = aStartColor;
        this.itsEndColor = aEndColor;
        this.itsBorderWidth = 4.0f;
        this.itsBorderColor = this.itsEndColor;
        this.itsGradientLength = 1.0;
        this.itsBorder = true;
        this.itsBorderType = BORDER_RECTANGLE;
    }

    public void setGradientLength(double length) {
        this.itsGradientLength = length;
    }

    public void setBorderWidth(float aWidth) {
        this.itsBorderWidth = aWidth;
    }

    public void setBorderColor(Color aColor) {
        this.itsBorderColor = aColor;
    }

    public void setBorder(boolean aBorder) {
        this.itsBorder = aBorder;
    }

    public void setColors(Color startColor, Color endColor) {
        this.itsStartColor = startColor;
        this.itsEndColor = endColor;
    }

    public void setBorderType(String aType) {
        this.itsBorderType = aType;
    }

    public void paintComponent(Graphics g) {
        GradientPaint gradient;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.itsFadeDirection.equals(TOP_BOTTOM)) {
            gradient = new GradientPaint(0.0f, 0.0f, this.itsStartColor, 0.0f, (int)((double)height * this.itsGradientLength), this.itsEndColor);
            g2.setPaint(gradient);
        }
        if (this.itsFadeDirection.equals(BOTTOM_TOP)) {
            gradient = new GradientPaint(0.0f, 0.0f, this.itsEndColor, 0.0f, (int)((double)height * this.itsGradientLength), this.itsStartColor);
            g2.setPaint(gradient);
        }
        if (this.itsFadeDirection.equals(LEFT_RIGHT)) {
            gradient = new GradientPaint(0.0f, 0.0f, this.itsStartColor, (int)((double)width * this.itsGradientLength), 0.0f, this.itsEndColor);
            g2.setPaint(gradient);
        }
        if (this.itsFadeDirection.equals(RIGHT_LEFT)) {
            gradient = new GradientPaint((int)((double)width * this.itsGradientLength), 0.0f, this.itsStartColor, 0.0f, 0.0f, this.itsEndColor);
            g2.setPaint(gradient);
        }
        if (this.itsFadeDirection.equals(TOPLEFT_BOTTOMRIGHT)) {
            gradient = new GradientPaint(0.0f, 0.0f, this.itsStartColor, (int)((double)width * this.itsGradientLength), (int)((double)height * this.itsGradientLength), this.itsEndColor);
            g2.setPaint(gradient);
        }
        if (this.itsFadeDirection.equals(IN_OUT)) {
            gradient = new GradientPaint(0.0f, 10.0f, Color.RED, (int)((double)width * this.itsGradientLength), 0.0f, this.itsEndColor);
            g2.setPaint(gradient);
            gradient = new GradientPaint(0.0f, 0.0f, Color.BLUE, (int)((double)width * this.itsGradientLength), 0.0f, this.itsEndColor);
            g2.setPaint(gradient);
        }
        g2.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        if (this.itsBorder) {
            g2.setStroke(new BasicStroke(this.itsBorderWidth));
            g2.setPaint(this.itsBorderColor);
            if (this.itsBorderType.equals(BORDER_RECTANGLE)) {
                g2.draw(new Rectangle2D.Double(0.0, 0.0, width - 1, height - 1));
            }
            if (this.itsBorderType.equals(BORDER_TOP)) {
                g2.draw(new Line2D.Double(new Point(0, 0), new Point(width, 0)));
            }
        }
        super.paintComponent(g2);
    }

    public void setText(String text, boolean center) {
        this.initLabel();
        this._label.setText(text);
        if (center) {
            this._label.setHorizontalAlignment(0);
        }
    }

    private void initLabel() {
        if (this._label == null) {
            this._label = new JLabel();
            this.addComponentListener(new ThisComponentListner());
            this.add(this._label);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.initLabel();
        this._label.setFont(font);
    }

    public void setForeground(Color color) {
        this.initLabel();
        this._label.setForeground(color);
        super.setForeground(color);
    }

    public void setHorizontalAlignment(int align) {
        this._label.setHorizontalAlignment(align);
    }

    public ComponentListener getComponentListener() {
        return new ThisComponentListner();
    }

    private class ThisComponentListner
    extends ComponentAdapter {
        private ThisComponentListner() {
        }

        public void componentResized(ComponentEvent e) {
            GradientArea.this._label.setBounds(10, 0, e.getComponent().getWidth(), e.getComponent().getHeight());
        }
    }
}

