/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarRowHeader;
import bizcal.swing.CalendarView;
import bizcal.swing.DaysHoursHeaderPanel;
import bizcal.swing.StringLengthFormater;
import bizcal.swing.util.FrameArea;
import bizcal.util.BizcalException;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import bizcal.util.LocaleBroker;
import bizcal.util.TextUtil;
import bizcal.util.TimeOfDay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GroupView
extends CalendarView {
    private static final int LABEL_COL_WIDTH = 70;
    public static final int HOUR_RESOLUTION = 2;
    public static final int PREFERRED_HOUR_WIDTH = 10;
    public static final int PREFERRED_ROW_HEIGHT = 40;
    private List<List<FrameArea>> frameAreaRows = new ArrayList<List<FrameArea>>();
    private List eventRows = new ArrayList();
    private Map vLines = new HashMap();
    private List hLines = new ArrayList();
    private JLayeredPane calPanel;
    private JScrollPane scrollPane;
    private DaysHoursHeaderPanel columnHeader;
    private CalendarRowHeader rowHeader;
    private List calBackgrounds = new ArrayList();
    private int dayCount;

    public GroupView(CalendarViewConfig config, CalendarModel model) throws Exception {
        super(config);
        this.setModel(model);
        this.font = new Font("Verdana", 0, 10);
        this.calPanel = new JLayeredPane();
        this.calPanel.setLayout(new Layout());
        CalendarView.ThisMouseListener mouseListener = new CalendarView.ThisMouseListener();
        this.calPanel.addMouseListener(mouseListener);
        this.calPanel.addMouseMotionListener(mouseListener);
        this.scrollPane = new JScrollPane(this.calPanel, 20, 30);
        this.scrollPane.setCursor(Cursor.getDefaultCursor());
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(15);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.createCorner(true, true));
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", this.createCorner(true, false));
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.createCorner(false, true));
        this.columnHeader = new DaysHoursHeaderPanel(config, model);
        this.scrollPane.setColumnHeaderView(this.columnHeader.getComponent());
        this.rowHeader = new CalendarRowHeader(model, config);
        this.rowHeader.setFooterHeight(0);
        this.scrollPane.setRowHeaderView(this.rowHeader.getComponent());
    }

    public void refresh0() throws Exception {
        Object cal2;
        this.calPanel.removeAll();
        this.calPanel.setBackground(Color.WHITE);
        this.frameAreaRows.clear();
        this.eventRows.clear();
        this.hLines.clear();
        this.vLines.clear();
        this.calBackgrounds.clear();
        this.dayCount = DateUtil.getDateDiff(this.getModel().getInterval().getEndDate(), this.getModel().getInterval().getStartDate());
        this.addDraggingComponents(this.calPanel);
        JLabel hLine = new JLabel();
        hLine.setBackground(this.getDescriptor().getLineColor());
        hLine.setOpaque(true);
        this.calPanel.add((Component)hLine, (Object)1);
        this.hLines.add(hLine);
        for (Object cal2 : this.getModel().getSelectedCalendars()) {
            Object calId = ((Calendar)cal2).getId();
            String calHeader = ((Calendar)cal2).getSummary();
            calHeader = StringLengthFormater.formatNameString(calHeader, this.font, 65);
            hLine = new JLabel();
            hLine.setBackground(this.getDescriptor().getLineColor());
            hLine.setOpaque(true);
            this.calPanel.add((Component)hLine, (Object)1);
            this.hLines.add(hLine);
            ArrayList<FrameArea> frameAreas = new ArrayList<FrameArea>();
            this.frameAreaRows.add(frameAreas);
            List<Event> events = this.getModel().getEvents(calId);
            Collections.sort(events);
            this.eventRows.add(events);
            for (Event event : events) {
                FrameArea area = this.createFrameArea(calId, event);
                frameAreas.add(area);
                this.calPanel.add((Component)area, (Object)event.getLevel());
            }
        }
        cal2 = java.util.Calendar.getInstance(LocaleBroker.getLocale());
        ((java.util.Calendar)cal2).setTime(this.getInterval().getStartDate());
        while (((java.util.Calendar)cal2).getTime().getTime() < this.getInterval().getEndDate().getTime()) {
            Date date = ((java.util.Calendar)cal2).getTime();
            JLabel line = new JLabel();
            line.setBackground(this.getDescriptor().getLineColor2());
            line.setOpaque(true);
            this.calPanel.add((Component)line, (Object)2);
            this.vLines.put(date, line);
            if (this.dayCount <= 7) {
                TimeOfDay timeOfDay;
                TimeOfDay startTime = this.getDescriptor().getStartView();
                ((java.util.Calendar)cal2).set(11, startTime.getHour());
                ((java.util.Calendar)cal2).set(12, startTime.getMinute());
                ((java.util.Calendar)cal2).set(13, 0);
                ((java.util.Calendar)cal2).set(14, 0);
                TimeOfDay endTime = this.getDescriptor().getEndView();
                while ((timeOfDay = new TimeOfDay(((java.util.Calendar)cal2).getTime())).getValue() < endTime.getValue()) {
                    line = new JLabel();
                    line.setBackground(this.getDescriptor().getLineColor());
                    line.setOpaque(true);
                    this.calPanel.add((Component)line, (Object)2);
                    this.vLines.put(((java.util.Calendar)cal2).getTime(), line);
                    ((java.util.Calendar)cal2).add(10, 2);
                }
            }
            ((java.util.Calendar)cal2).add(6, 1);
            ((java.util.Calendar)cal2).set(11, 0);
            ((java.util.Calendar)cal2).set(12, 0);
            ((java.util.Calendar)cal2).set(13, 0);
            ((java.util.Calendar)cal2).set(14, 0);
        }
        for (Calendar calendar : this.getSelectedCalendars()) {
            JPanel calBackground = new JPanel();
            calBackground.setBackground(calendar.getColor());
            this.calBackgrounds.add(calBackground);
            this.calPanel.add((Component)calBackground, (Object)1);
        }
        this.calPanel.validate();
        this.calPanel.repaint();
        this.columnHeader.setModel(this.getModel());
        this.columnHeader.refresh();
        this.rowHeader.refresh();
    }

    private int getWidth() {
        return this.calPanel.getWidth();
    }

    private int getHeight() {
        return this.calPanel.getHeight();
    }

    protected int getCaptionRowHeight() {
        return 0;
    }

    protected int getXOffset() {
        return 0;
    }

    private int getTimeHeight() {
        return this.getHeight() - this.getCaptionRowHeight();
    }

    private int getTimeWidth() {
        return this.getWidth() - this.getXOffset();
    }

    private int getRowHeight() throws Exception {
        return 40;
    }

    private int getXPos(Date date) throws Exception {
        TimeOfDay time = new TimeOfDay(date);
        long x = time.getValue() - this.getDescriptor().getStartView().getValue();
        if (x < 0L) {
            x = 0L;
        }
        long dayViewDuration = this.getDescriptor().getEndView().getValue() - this.getDescriptor().getStartView().getValue();
        double ratio = (double)x / (double)dayViewDuration;
        double dayWidth = this.getDayWidth();
        int datediff = DateUtil.getDateDiff(date, this.getInterval().getStartDate());
        return (int)((double)this.getXOffset() + (double)datediff * dayWidth + ratio * dayWidth);
    }

    private double getDayWidth() throws Exception {
        long duration = this.getInterval().getDuration();
        duration = duration / 24L / 3600L / 1000L;
        return (double)this.getTimeWidth() / (double)duration;
    }

    protected LayoutManager getLayout() {
        return new Layout();
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    protected Date getDate(int xPos, int yPos) throws Exception {
        double daywidth = this.getDayWidth();
        int dayno = (int)((double)(xPos -= this.getXOffset()) / daywidth);
        xPos = (int)((double)xPos - (double)dayno * daywidth);
        double ratio = (double)xPos / daywidth;
        Date date = this.getInterval().getStartDate();
        date = DateUtil.getDiffDay(date, dayno);
        long dayViewDuration = this.getDescriptor().getEndView().getValue() - this.getDescriptor().getStartView().getValue();
        long startTime = this.getDescriptor().getStartView().getValue();
        long passedTime = (long)(ratio * (double)dayViewDuration);
        TimeOfDay timeOfDay = new TimeOfDay(startTime + passedTime);
        date = timeOfDay.getDate(date);
        return date;
    }

    protected Object getCalendarId(int x, int y) throws Exception {
        int pos = y / this.getRowHeight();
        if (pos >= this.getSelectedCalendars().size()) {
            return null;
        }
        Calendar cal = (Calendar)this.getSelectedCalendars().get(pos);
        return cal.getId();
    }

    protected String getHeaderText() throws Exception {
        Date from = this.getInterval().getStartDate();
        java.util.Calendar date = java.util.Calendar.getInstance(LocaleBroker.getLocale());
        date.setTime(this.getInterval().getEndDate());
        date.add(5, -1);
        SimpleDateFormat format = new SimpleDateFormat("MMMM yyyy", LocaleBroker.getLocale());
        return TextUtil.formatCase(format.format(from));
    }

    private int getHourCount() throws Exception {
        return this.getDescriptor().getEndView().getHour() - this.getDescriptor().getStartView().getHour();
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            try {
                DateInterval interval = GroupView.this.getModel().getInterval();
                int dayCount = DateUtil.getDateDiff(interval.getEndDate(), interval.getStartDate());
                int width = dayCount * GroupView.this.getHourCount() * 10;
                int height = 400;
                return new Dimension(width, height);
            }
            catch (Exception e) {
                throw BizcalException.create(e);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(50, 100);
        }

        public void layoutContainer(Container parent0) {
            try {
                int width = GroupView.this.getWidth();
                int height = GroupView.this.getHeight();
                int yoffset = GroupView.this.getCaptionRowHeight();
                int rowHeight = GroupView.this.getRowHeight();
                JLabel hLine = (JLabel)GroupView.this.hLines.get(0);
                hLine.setBounds(0, 0, width, 1);
                int yPos = yoffset;
                int i = 0;
                while (i < GroupView.this.eventRows.size()) {
                    Rectangle r;
                    Event event;
                    List areas = (List)GroupView.this.frameAreaRows.get(i);
                    List events = (List)GroupView.this.eventRows.get(i);
                    Component prevArea = null;
                    int overlapCol = 0;
                    int overlapColCount = 0;
                    int[] overlapCols = new int[events.size()];
                    int j = 0;
                    while (j < areas.size()) {
                        FrameArea area = (FrameArea)areas.get(j);
                        event = (Event)events.get(j);
                        int x1 = GroupView.this.getXPos(event.getStart());
                        int x2 = GroupView.this.getXPos(event.getEnd());
                        area.setBounds(x1, yPos, x2 - x1, rowHeight);
                        if (!event.isBackground()) {
                            if (prevArea != null) {
                                r = prevArea.getBounds();
                                int prevX2 = r.x + r.width;
                                if (prevX2 > x1) {
                                    ++overlapCol;
                                    if (prevX2 < x2) {
                                        prevArea = area;
                                    }
                                } else {
                                    overlapCol = 0;
                                    prevArea = area;
                                }
                            } else {
                                prevArea = area;
                            }
                            overlapCols[j] = overlapCol;
                            if (overlapCol > overlapColCount) {
                                overlapColCount = overlapCol;
                            }
                        } else {
                            overlapCols[j] = 0;
                        }
                        ++j;
                    }
                    if (overlapColCount > 0) {
                        int slotHeight = rowHeight / (overlapColCount + 1);
                        int j2 = 0;
                        while (j2 < areas.size()) {
                            event = (Event)events.get(j2);
                            if (!event.isBackground()) {
                                FrameArea area = (FrameArea)areas.get(j2);
                                int index = overlapCols[j2];
                                r = area.getBounds();
                                area.setBounds(r.x, r.y + index * slotHeight, r.width, slotHeight);
                            }
                            ++j2;
                        }
                    }
                    hLine = (JLabel)GroupView.this.hLines.get(i + 1);
                    hLine.setBounds(0, yPos + rowHeight, width, 1);
                    yPos += rowHeight;
                    ++i;
                }
                int captionHeight = GroupView.this.getCaptionRowHeight() / 2;
                java.util.Calendar cal = java.util.Calendar.getInstance(LocaleBroker.getLocale());
                cal.setTime(GroupView.this.getInterval().getStartDate());
                while (cal.getTime().getTime() < GroupView.this.getInterval().getEndDate().getTime()) {
                    Date date = cal.getTime();
                    int xpos = GroupView.this.getXPos(date);
                    JLabel line = (JLabel)GroupView.this.vLines.get(date);
                    line.setBounds(xpos, 0, 1, height);
                    if (GroupView.this.dayCount <= 7) {
                        TimeOfDay timeOfDay;
                        TimeOfDay startTime = GroupView.this.getDescriptor().getStartView();
                        cal.set(11, startTime.getHour());
                        cal.set(12, startTime.getMinute());
                        cal.set(13, 0);
                        cal.set(14, 0);
                        TimeOfDay endTime = GroupView.this.getDescriptor().getEndView();
                        while ((timeOfDay = new TimeOfDay(cal.getTime())).getValue() < endTime.getValue()) {
                            xpos = GroupView.this.getXPos(cal.getTime());
                            line = (JLabel)GroupView.this.vLines.get(cal.getTime());
                            line.setBounds(xpos, captionHeight, 1, height - captionHeight);
                            cal.add(10, 2);
                        }
                    }
                    cal.add(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                }
                yPos = yoffset;
                int iCal = 0;
                while (iCal < GroupView.this.calBackgrounds.size()) {
                    int x1 = GroupView.this.getXOffset();
                    int x2 = GroupView.this.getWidth();
                    JPanel calBackground = (JPanel)GroupView.this.calBackgrounds.get(iCal);
                    calBackground.setBounds(x1, yPos, x2 - x1, rowHeight);
                    yPos += rowHeight;
                    ++iCal;
                }
            }
            catch (Exception e) {
                throw BizcalException.create(e);
            }
        }
    }
}

