/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.TableLayoutPanel;
import bizcal.util.BizcalException;
import bizcal.util.DateUtil;
import bizcal.util.LocaleBroker;
import bizcal.util.StreamCopier;
import bizcal.util.TextUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DayStepper {
    private TableLayoutPanel panel;
    private Calendar cal;
    private JComboBox yearCombo;
    private JComboBox monthCombo;
    private JComboBox dayCombo;
    private List listeners = new ArrayList();
    private String fastRewindArrow = "/bizcal/res/go_fb.gif";
    private String prevArrow = "/bizcal/res/go_back.gif";
    private String nextArrow = "/bizcal/res/go_forward.gif";
    private String fastForwardArrow = "/bizcal/res/go_ff.gif";

    public DayStepper() throws Exception {
        this.cal = Calendar.getInstance(LocaleBroker.getLocale());
        this.cal.setTime(DateUtil.round2Day(new Date()));
        this.panel = new TableLayoutPanel();
        this.panel.createColumn();
        this.panel.createColumn();
        this.panel.createColumn(-1.0);
        this.panel.createColumn();
        this.panel.createColumn(10.0);
        this.panel.createColumn();
        this.panel.createColumn(10.0);
        this.panel.createColumn();
        this.panel.createColumn(-1.0);
        this.panel.createColumn();
        this.panel.createColumn();
        TableLayoutPanel.Row row = this.panel.createRow();
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    DayStepper.this.previousMonth();
                }
                catch (Exception e) {
                    ErrorHandler.handleError(e);
                }
            }
        };
        row.createCell(this.createButton(this.fastRewindArrow, listener));
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    DayStepper.this.previous();
                }
                catch (Exception e) {
                    ErrorHandler.handleError(e);
                }
            }
        };
        row.createCell(this.createButton(this.prevArrow, listener));
        row.createCell();
        this.initYearCombo();
        this.initMonthCombo();
        this.initDayCombo();
        this.setCombos();
        row.createCell(this.yearCombo);
        row.createCell();
        row.createCell(this.monthCombo);
        row.createCell();
        row.createCell(this.dayCombo);
        row.createCell();
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    DayStepper.this.next();
                }
                catch (Exception e) {
                    ErrorHandler.handleError(e);
                }
            }
        };
        row.createCell(this.createButton(this.nextArrow, listener));
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    DayStepper.this.nextMonth();
                }
                catch (Exception e) {
                    ErrorHandler.handleError(e);
                }
            }
        };
        row.createCell(this.createButton(this.fastForwardArrow, listener));
    }

    private void initYearCombo() throws Exception {
        this.yearCombo = new JComboBox();
        int year = this.cal.get(1);
        int i = year - 1;
        while (i < year + 4) {
            this.yearCombo.addItem(i);
            ++i;
        }
        this.yearCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                try {
                    int year = (Integer)DayStepper.this.yearCombo.getSelectedItem();
                    DayStepper.this.cal.set(1, year);
                }
                catch (Exception e) {
                    throw BizcalException.create(e);
                }
            }
        });
    }

    private void initMonthCombo() throws Exception {
        this.monthCombo = new JComboBox();
        SimpleDateFormat format = new SimpleDateFormat("MMMMM", LocaleBroker.getLocale());
        int orgMonth = this.cal.get(2);
        int i = 0;
        while (i < 12) {
            this.cal.set(2, i);
            MonthWrapper wrapper = new MonthWrapper(i, TextUtil.formatCase(format.format(this.cal.getTime())));
            this.monthCombo.addItem(wrapper);
            ++i;
        }
        this.cal.set(2, orgMonth);
        this.monthCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                try {
                    int month = ((MonthWrapper)DayStepper.this.monthCombo.getSelectedItem()).getValue();
                    DayStepper.this.cal.set(2, month);
                    DayStepper.this.refreshDayCombo();
                }
                catch (Exception e) {
                    throw BizcalException.create(e);
                }
            }
        });
    }

    private void initDayCombo() throws Exception {
        this.dayCombo = new JComboBox();
        int currDay = this.cal.get(5);
        this.refreshDayCombo();
        this.dayCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                Integer selectedItem = (Integer)DayStepper.this.dayCombo.getSelectedItem();
                if (selectedItem == null) {
                    return;
                }
                int day = (Integer)DayStepper.this.dayCombo.getSelectedItem();
                DayStepper.this.cal.set(5, day);
            }
        });
        this.cal.set(5, currDay);
    }

    private void setCombos() {
        int year = this.cal.get(1);
        this.yearCombo.setSelectedItem(year);
        int month = this.cal.get(2);
        this.monthCombo.setSelectedIndex(month);
        int day = this.cal.get(5);
        this.dayCombo.setSelectedItem(day);
    }

    private void refreshDayCombo() {
        Integer selectedItem = (Integer)this.dayCombo.getSelectedItem();
        int dayNo = 1;
        if (selectedItem != null) {
            dayNo = selectedItem;
        }
        this.dayCombo.removeAllItems();
        int maxDayNo = this.cal.getActualMaximum(5);
        int i = 1;
        while (i <= maxDayNo) {
            this.dayCombo.addItem(i);
            ++i;
        }
        this.dayCombo.setSelectedItem(dayNo);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public Date getDate() {
        return this.cal.getTime();
    }

    private void next() throws Exception {
        this.cal.add(5, 1);
        this.setCombos();
        this.fireStateChanged();
    }

    private void previous() throws Exception {
        this.cal.add(5, -1);
        this.setCombos();
        this.fireStateChanged();
    }

    private void nextMonth() throws Exception {
        this.cal.add(2, 1);
        this.setCombos();
        this.fireStateChanged();
    }

    private void previousMonth() throws Exception {
        this.cal.add(2, -1);
        this.setCombos();
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    private void fireStateChanged() throws Exception {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(event);
        }
    }

    private Icon getIcon(String filename) throws Exception {
        byte[] bytes = StreamCopier.copyToByteArray(this.getClass().getResourceAsStream(filename));
        return new ImageIcon(bytes);
    }

    private JComponent createButton(String filename, ActionListener listener) throws Exception {
        JButton button = new JButton(this.getIcon(filename));
        button.addActionListener(listener);
        return button;
    }

    public void setDate(Date date) throws Exception {
        this.cal.setTime(DateUtil.round2Day(date));
        this.setCombos();
        this.fireStateChanged();
    }

    private class MonthWrapper {
        private int value;
        private String caption;

        public MonthWrapper(int value, String caption) {
            this.value = value;
            this.caption = caption;
        }

        public String toString() {
            return this.caption;
        }

        public int getValue() {
            return this.value;
        }
    }
}

