/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.swing.CalendarSelectionListener;
import bizcal.swing.PopupMenuCallback;
import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.GradientArea;
import bizcal.swing.util.TableLayoutPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class CalendarList {
    private static int GRADIENT_TOP_HEIGHT = 30;
    private CalendarModel _broker;
    private TableLayoutPanel _panel;
    private JSplitPane _splitPanel = new JSplitPane(0);
    private Map _checkBoxes;
    private Set _listeners = new HashSet();
    private Object _currCalId;
    private int width;
    private Font font = new Font("Arial", 12, 10);
    private Color primaryColor;
    private Color secondaryColor;
    private PopupMenuCallback popupMenuCallback;
    private JLabel header;
    private JLabel groupName;
    private Object projectId;
    private List calendarList;

    public CalendarList(Object projId, CalendarModel broker) throws Exception {
        this.projectId = projId;
        this.primaryColor = new Color(200, 200, 200);
        this.secondaryColor = Color.WHITE;
        this._broker = broker;
        this.init();
    }

    public void setBroker(CalendarModel broker) throws Exception {
        this._broker = broker;
        this.init();
    }

    private void init() throws Exception {
        if (this._panel != null) {
            return;
        }
        this._panel = new TableLayoutPanel();
        this._panel.addComponentListener(new ThisComponentListener());
        this.build();
    }

    public void refresh() throws Exception {
        this._panel.deleteColumns();
        this._panel.deleteRows();
        this._panel.clear();
        this.build();
        this.fireCalendarsSelected();
    }

    private void build() throws Exception {
        this._panel.setBackground(Color.WHITE);
        this._panel.createColumn();
        this._panel.createColumn(-1.0);
        this._panel.createColumn(5.0);
        TableLayoutPanel.Row ro = this._panel.createRow(30.0);
        TableLayoutPanel.Cell cell = ro.createCell();
        cell.setColumnSpan(3);
        GradientArea headerGradientArea = new GradientArea("TOP_BOTTOM", this.secondaryColor, this.primaryColor);
        headerGradientArea.setGradientLength(0.5);
        if (this.header == null) {
            this.header = new JLabel("Planeringsgrupp", 0);
            this.header.setFont(this.font.deriveFont(1, 12.0f));
            this.header.setForeground(Color.WHITE);
        }
        headerGradientArea.add(this.header);
        headerGradientArea.setBorderWidth(0.2f);
        headerGradientArea.setBorderColor(Color.LIGHT_GRAY);
        cell.put(headerGradientArea);
        ro = this._panel.createRow(20.0);
        cell = ro.createCell();
        cell.setColumnSpan(3);
        GradientArea topGradientArea = new GradientArea("TOP_BOTTOM", new Color(255, 255, 255), new Color(245, 245, 245));
        topGradientArea.setOpaque(true);
        cell.put(topGradientArea);
        String projectName = "Unknown";
        if (this.projectId != null) {
            projectName = "Calendars";
        }
        if (this.groupName == null) {
            this.groupName = new JLabel(projectName);
        }
        this.groupName.addMouseListener(new ProjectLabelMouseListener(this.projectId));
        this.groupName.setText(projectName);
        this.groupName.setFont(this.font);
        this.groupName.setForeground(Color.BLACK);
        topGradientArea.add(this.groupName);
        Map oldCheckBoxes = this._checkBoxes;
        this._checkBoxes = new HashMap();
        TableLayoutPanel checkboxPanel = new TableLayoutPanel();
        checkboxPanel.setBackground(Color.WHITE);
        checkboxPanel.createColumn(-1.0);
        checkboxPanel.createColumn(15.0);
        this.calendarList = this._broker.getCalendars();
        Iterator i = this.calendarList.iterator();
        boolean first = true;
        while (i.hasNext()) {
            JCheckBox oldCheckBox;
            Calendar cal = (Calendar)i.next();
            Object id = cal.getId();
            String name = cal.getSummary();
            TableLayoutPanel.Row row = checkboxPanel.createRow();
            JCheckBox checkBox = new JCheckBox(name);
            checkBox.addMouseListener(new CalMouseListener(id));
            checkBox.setFont(this.font);
            checkBox.setOpaque(false);
            checkBox.setActionCommand("select");
            CheckBoxListener listener = new CheckBoxListener(checkBox, cal.getId());
            checkBox.addActionListener(listener);
            this._checkBoxes.put(id, checkBox);
            if (first && checkBox.isEnabled()) {
                checkBox.setSelected(true);
                first = false;
            }
            if (oldCheckBoxes != null && (oldCheckBox = (JCheckBox)oldCheckBoxes.get(id)) != null) {
                checkBox.setSelected(oldCheckBox.isSelected());
            }
            row.createCell(checkBox);
            if (cal.isEnabled()) continue;
            checkBox.setEnabled(cal.isEnabled());
            checkBox.setFont(this.font.deriveFont(2));
        }
        JScrollPane scrollPanel = new JScrollPane(checkboxPanel, 20, 31);
        scrollPanel.setBorder(null);
        this._splitPanel.setBackground(Color.WHITE);
        this._splitPanel.setBorder(null);
        this._splitPanel.setDividerSize(0);
        this._splitPanel.setTopComponent(this._panel);
        this._splitPanel.setBottomComponent(scrollPanel);
    }

    public JComponent getComponent() {
        return this._splitPanel;
    }

    public void addListener(CalendarSelectionListener listener) {
        this._listeners.add(listener);
    }

    private void fireCalendarsSelected() throws Exception {
        List selectedCals = this.getSelectedCalendars();
        for (CalendarSelectionListener listener : this._listeners) {
            listener.calendarSelected(selectedCals);
        }
    }

    public List getSelectedCalendars() throws Exception {
        ArrayList<Calendar> selectedCals = new ArrayList<Calendar>();
        for (Calendar cal : this.calendarList) {
            JCheckBox checkBox = (JCheckBox)this._checkBoxes.get(cal.getId());
            if (checkBox == null || !checkBox.isSelected()) continue;
            selectedCals.add(cal);
        }
        return selectedCals;
    }

    public void setPopupMenuCallback(PopupMenuCallback popupMenuCallback) {
        this.popupMenuCallback = popupMenuCallback;
    }

    public void setProjectId(Object projectId) {
        this.projectId = projectId;
    }

    private class CalMouseListener
    extends MouseAdapter {
        private Object _calId;

        public CalMouseListener(Object id) {
            this._calId = id;
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            try {
                if (e.isPopupTrigger()) {
                    JPopupMenu popup;
                    CalendarList.this._currCalId = this._calId;
                    if (CalendarList.this.popupMenuCallback != null) {
                        popup = CalendarList.this.popupMenuCallback.getCalendarPopupMenu(this._calId);
                    } else {
                        popup = new JPopupMenu();
                        JMenuItem item = new JMenuItem("Ta bort");
                        popup.add(item);
                        item.addActionListener(new DeleteListener());
                    }
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
            catch (Exception exc) {
                ErrorHandler.handleError(exc);
            }
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        public CheckBoxListener(JCheckBox checkBox, Object id) {
        }

        public void actionPerformed(ActionEvent event) {
            try {
                CalendarList.this.fireCalendarsSelected();
            }
            catch (Exception e) {
                ErrorHandler.handleError(e);
            }
        }
    }

    private class DeleteListener
    implements ActionListener {
        private DeleteListener() {
        }

        public void actionPerformed(ActionEvent event) {
            try {
                CalendarList.this._broker.deleteCalendar(CalendarList.this._currCalId);
                CalendarList.this.refresh();
            }
            catch (Exception e) {
                ErrorHandler.handleError(e);
            }
        }
    }

    private class ProjectLabelMouseListener
    extends MouseAdapter {
        public ProjectLabelMouseListener(Object id) {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            try {
                if (e.isPopupTrigger()) {
                    JPopupMenu popup = CalendarList.this.popupMenuCallback != null ? CalendarList.this.popupMenuCallback.getProjectPopupMenu(CalendarList.this.projectId) : new JPopupMenu();
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
            catch (Exception exc) {
                ErrorHandler.handleError(exc);
            }
        }
    }

    private class ThisComponentListener
    extends ComponentAdapter {
        private ThisComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            try {
                CalendarList.this.width = CalendarList.this._panel.getWidth();
                CalendarList.this.header.setBounds(0, 0, CalendarList.this.width, GRADIENT_TOP_HEIGHT);
                CalendarList.this.groupName.setBounds(5, 0, CalendarList.this.width - 5, 20);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                ErrorHandler.handleError(exc);
            }
        }
    }
}

