/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.imageioimpl.plugins.dcm;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.TransferSyntax;
import org.dcm4che2.data.VR;
import org.dcm4che2.imageio.ImageWriterFactory;
import org.dcm4che2.imageio.plugins.dcm.DicomStreamMetaData;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.util.UIDUtils;

public class DicomImageWriter
extends ImageWriter {
    protected DicomOutputStream dos;
    protected ImageWriter writer;
    protected ImageWriteParam writeParam;
    protected boolean encapsulated = true;
    private int bytes;

    public DicomImageWriter(ImageWriterSpi spi) {
        super(spi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata metadata, ImageTypeSpecifier type, ImageWriteParam param) {
        this.setupWriter(metadata);
        return this.writer.convertImageMetadata(metadata, type, param);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata metadata, ImageWriteParam param) {
        if (metadata instanceof DicomStreamMetaData) {
            return metadata;
        }
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier image, ImageWriteParam writeParam) {
        if (this.writer != null) {
            return this.writer.getDefaultImageMetadata(image, writeParam);
        }
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam arg0) {
        DicomStreamMetaData ret = new DicomStreamMetaData();
        BasicDicomObject dobj = new BasicDicomObject();
        ret.setDicomObject((DicomObject)dobj);
        Date now = new Date();
        dobj.putString(131088, VR.UI, "1.2.840.10008.1.2.4.50");
        dobj.putString(524388, VR.CS, "WSD");
        dobj.putString(524384, VR.CS, "OT");
        dobj.putInt(2097171, VR.IS, 1);
        dobj.putDate(1576978, VR.DA, now);
        dobj.putDate(1576980, VR.TM, now);
        dobj.putString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.7");
        dobj.putString(524312, VR.UI, UIDUtils.createUID());
        return ret;
    }

    public void updateDicomHeader(DicomStreamMetaData metadata, BufferedImage image) {
        DicomObject dobj = metadata.getDicomObject();
        if (dobj.containsValue(2621697)) {
            return;
        }
        int numSamples = image.getColorModel().getNumComponents();
        if (numSamples == 4) {
            numSamples = 3;
        }
        dobj.putInt(0x280002, VR.US, numSamples);
        int bits = image.getColorModel().getComponentSize(0);
        int allocated = 8;
        if (bits > 8) {
            allocated = 16;
        }
        dobj.putInt(2621697, VR.US, bits);
        dobj.putInt(2621696, VR.US, allocated);
        dobj.putInt(2621457, VR.US, image.getWidth());
        dobj.putInt(2621456, VR.US, image.getHeight());
    }

    public void write(IIOMetadata metadata, IIOImage iioimage, ImageWriteParam param) throws IOException {
        DicomStreamMetaData dmeta = (DicomStreamMetaData)metadata;
        if (dmeta == null) {
            dmeta = (DicomStreamMetaData)this.getDefaultStreamMetadata(param);
            metadata = dmeta;
            this.updateDicomHeader(dmeta, (BufferedImage)iioimage.getRenderedImage());
        }
        this.prepareWriteSequence(metadata);
        this.writeToSequence(iioimage, param);
        this.endWriteSequence();
    }

    public boolean canWriteSequence() {
        return true;
    }

    protected void setupWriter(IIOMetadata metadata) {
        if (this.writer != null) {
            return;
        }
        if (metadata == null) {
            metadata = this.getDefaultStreamMetadata(null);
        }
        DicomStreamMetaData dmeta = (DicomStreamMetaData)metadata;
        DicomObject dobj = dmeta.getDicomObject();
        String tsuid = dobj.getString(131088);
        TransferSyntax ts = TransferSyntax.valueOf((String)tsuid);
        this.encapsulated = ts.encapsulated();
        if (this.encapsulated) {
            this.writer = ImageWriterFactory.getInstance().getWriterForTransferSyntax(tsuid);
            this.writeParam = ImageWriterFactory.getInstance().createWriteParam(tsuid, this.writer);
        } else {
            this.writer = ImageIO.getImageWritersByFormatName("RAW").next();
        }
    }

    public void prepareWriteSequence(IIOMetadata metadata) throws IOException {
        if (this.dos != null) {
            throw new IOException("Already written the DICOM object header - can't write it again.");
        }
        DicomStreamMetaData dmeta = (DicomStreamMetaData)metadata;
        DicomObject dobj = dmeta.getDicomObject();
        Object output = this.getOutput();
        this.dos = new DicomOutputStream((DataOutput)((ImageOutputStream)output));
        this.dos.setAutoFinish(false);
        if (dmeta.isFileMetaInfoIncluded()) {
            this.dos.writeDicomFile(dobj);
        } else {
            this.dos.writeDataset(dobj, dobj.getString(131088));
        }
        this.setupWriter(metadata);
        if (this.encapsulated) {
            this.dos.writeHeader(2145386512, VR.OB, -1);
            this.dos.writeHeader(-73728, null, 0);
        } else {
            int frames = dobj.getInt(0x280008, 1);
            int width = dobj.getInt(2621457);
            int height = dobj.getInt(2621456);
            this.bytes = (dobj.getInt(2621696, 8) + 7) / 8;
            int samples = dobj.getInt(0x280002);
            int size = frames * width * height * this.bytes * samples;
            VR vr = VR.OB;
            if (this.bytes > 1) {
                vr = VR.OW;
            }
            this.dos.writeHeader(2145386512, vr, size);
        }
        this.dos.flush();
        ((ImageOutputStream)output).flush();
    }

    public void writeToSequence(IIOImage iioimage, ImageWriteParam param) throws IOException {
        byte[] data = this.extractImageEncoding(iioimage, param);
        this.writeBytesToSequence(data, param);
    }

    public void writeBytesToSequence(byte[] data, ImageWriteParam param) throws IOException {
        if (this.encapsulated) {
            this.dos.writeHeader(-73728, null, data.length);
        }
        this.dos.write(data);
        this.dos.flush();
        ((ImageOutputStream)this.output).flush();
    }

    protected byte[] extractImageEncoding(IIOImage iioimage, ImageWriteParam param) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream imageOutput = new MemoryCacheImageOutputStream(baos);
        this.writer.setOutput(imageOutput);
        this.writer.write(null, iioimage, this.writeParam);
        imageOutput.close();
        baos.close();
        byte[] data = baos.toByteArray();
        if (!this.encapsulated && this.bytes == 2 && !this.dos.getTransferSyntax().bigEndian()) {
            for (int i = 0; i < data.length; i += 2) {
                byte swap = data[i];
                data[i] = data[i + 1];
                data[i + 1] = swap;
            }
        }
        return data;
    }

    public void endWriteSequence() throws IOException {
        if (this.encapsulated) {
            this.dos.writeHeader(-73507, null, 0);
        }
        this.dos.finish();
        ((ImageOutputStream)this.output).flush();
        this.dos = null;
        this.output = null;
        this.writer = null;
    }
}

