/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.imageioimpl.plugins.dcm;

import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che2.imageioimpl.plugins.dcm.DicomImageReader;

public class DicomImageReaderSpi
extends ImageReaderSpi {
    private static final String[] formatNames = new String[]{"dicom", "DICOM"};
    private static final String[] suffixes = new String[]{"dcm", "dic", "dicm", "dicom"};
    private static final String[] MIMETypes = new String[]{"application/dicom"};
    private static String vendor;
    private static String version;

    private static String maskNull(String s, String def) {
        return s != null ? s : def;
    }

    public DicomImageReaderSpi() {
        this(vendor, version, MIMETypes, "org.dcm4che2.imageioimpl.plugins.dcm.DicomImageReader", STANDARD_INPUT_TYPE, null, false, false);
    }

    protected DicomImageReaderSpi(String vendorName, String version, String[] MIMETypes, String readerClassName, Class[] inputTypes, String[] writerSpiNames, boolean supportsStandardStreamMetadataFormat, boolean supportsStandardImageMetadataFormat) {
        super(vendorName, version, formatNames, suffixes, MIMETypes, readerClassName, inputTypes, writerSpiNames, supportsStandardStreamMetadataFormat, null, null, null, null, supportsStandardImageMetadataFormat, null, null, null, null);
    }

    public String getDescription(Locale locale) {
        return "DICOM Image Reader";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecodeInput(Object input) throws IOException {
        if (!(input instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)input;
        byte[] b = new byte[132];
        stream.mark();
        try {
            stream.readFully(b);
        }
        catch (EOFException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            stream.reset();
        }
        if (b[128] == 68 && b[129] == 73 && b[130] == 67 && b[131] == 77) {
            return true;
        }
        try {
            if (b[0] == 0) {
                if (b[1] == 0) {
                    return false;
                }
                int len = (b[6] & 0xFF) << 8 | b[7] & 0xFF;
                return b[1] == b[len + 9];
            }
            if (b[1] != 0) {
                return false;
            }
            int len = b[6] & 0xFF | (b[7] & 0xFF) << 8;
            if (b[0] == b[len + 8]) {
                return true;
            }
            len = b[4] & 0xFF | (b[5] & 0xFF) << 8;
            return b[0] == b[len + 8];
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public ImageReader createReaderInstance(Object extension) {
        return new DicomImageReader(this);
    }

    static {
        Package p = DicomImageReaderSpi.class.getPackage();
        vendor = DicomImageReaderSpi.maskNull(p.getImplementationVendor(), "");
        version = DicomImageReaderSpi.maskNull(p.getImplementationVersion(), "");
    }
}

