/*
 * Decompiled with CFR 0.152.
 */
package nl.ow.dilemma.ant.jar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import nl.ow.dilemma.ant.jar.Tools;

public class UnsignJarImpl {
    public static void unsign(File jarfile) {
        if (!jarfile.canRead()) {
            System.err.println("Cannot read file " + jarfile.getAbsolutePath());
            return;
        }
        if (!jarfile.canWrite()) {
            System.err.println("Cannot write file " + jarfile.getAbsolutePath());
            return;
        }
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            FileInputStream fis = new FileInputStream(jarfile);
            UnsignJarImpl.unsign(fis, result);
            fis.close();
            Tools.writeArrayToFile(jarfile, result.toByteArray());
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void unsign(InputStream is, OutputStream os) {
        try {
            JarEntry src;
            JarInputStream jis = new JarInputStream(is);
            JarOutputStream jos = null;
            Manifest manifest = jis.getManifest();
            if (manifest == null) {
                jos = new JarOutputStream(os);
            } else {
                manifest.getEntries().clear();
                jos = new JarOutputStream(os, manifest);
            }
            byte[] buffer = null;
            while ((src = jis.getNextJarEntry()) != null) {
                String name = src.getName();
                String lName = name.toLowerCase();
                if (lName.startsWith("meta-inf") && (lName.endsWith(".rsa") || lName.endsWith(".dsa") || lName.endsWith(".sf"))) continue;
                buffer = UnsignJarImpl.getNextResource(jis);
                JarEntry dest = new JarEntry(name);
                jos.putNextEntry(dest);
                jos.write(buffer);
            }
            jos.close();
            jis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static byte[] getNextResource(JarInputStream jis) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int len = 0;
        while ((len = jis.read(b)) != -1) {
            baos.write(b, 0, len);
        }
        return baos.toByteArray();
    }
}

