/*
 * Decompiled with CFR 0.152.
 */
package nl.ow.dilemma.ant.jar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Tools {
    public static void writeArrayToFile(File resultFile, byte[] fullFile) throws IOException, FileNotFoundException {
        FileOutputStream file = new FileOutputStream(resultFile);
        file.write(fullFile);
        file.close();
    }

    public static byte[] readArrayFromFile(File srcFile) throws FileNotFoundException, IOException {
        int len;
        FileInputStream fis = new FileInputStream(srcFile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = fis.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        fis.close();
        baos.close();
        return baos.toByteArray();
    }

    public static void gzip(InputStream is, OutputStream os) throws IOException {
        int len;
        GZIPOutputStream gos = new GZIPOutputStream(os);
        byte[] buf = new byte[4096];
        while ((len = is.read(buf)) > 0) {
            gos.write(buf, 0, len);
        }
        is.close();
        gos.close();
    }

    public static void gzip(File jarfile) {
        if (!jarfile.canRead()) {
            System.err.println("Cannot read file " + jarfile.getAbsolutePath());
            return;
        }
        File dest = new File(jarfile.getAbsolutePath() + ".gz");
        try {
            FileInputStream fis = new FileInputStream(jarfile);
            FileOutputStream fos = new FileOutputStream(dest);
            Tools.gzip(fis, fos);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void gunzip(InputStream is, OutputStream os) throws IOException {
        int len;
        GZIPInputStream gis = new GZIPInputStream(is);
        byte[] buf = new byte[4096];
        while ((len = gis.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
        gis.close();
        os.close();
    }

    public static void gunzip(File jarfile) {
        if (!jarfile.canRead()) {
            System.err.println("Cannot read file " + jarfile.getAbsolutePath());
            return;
        }
        String shortName = jarfile.getAbsolutePath();
        if (!shortName.endsWith(".gz")) {
            System.err.println("Filename does not end with '.gz'");
            return;
        }
        shortName = shortName.substring(0, shortName.length() - 3);
        File dest = new File(shortName);
        try {
            FileInputStream fis = new FileInputStream(jarfile);
            FileOutputStream fos = new FileOutputStream(dest);
            Tools.gunzip(fis, fos);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

