/*
 * Decompiled with CFR 0.152.
 */
package nl.ow.dilemma.ant.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import nl.ow.dilemma.ant.jar.Tools;

public class Pack200Impl {
    public static String PACK_CLASS = "java.util.jar.Pack200";

    public static void pack(InputStream is, OutputStream os, Map params) throws IOException {
        if (!Pack200Impl.hasPack200()) {
            System.err.println(PACK_CLASS + " not found, Pack200 features not available.");
            return;
        }
        Pack200.Packer pack = Pack200.newPacker();
        if (params != null) {
            SortedMap packParams = pack.properties();
            packParams.putAll(params);
        }
        JarInputStream jis = new JarInputStream(is);
        pack.pack(jis, os);
        os.close();
    }

    public static void pack(File jarfile) {
        if (!jarfile.canRead()) {
            System.err.println("Cannot read file " + jarfile.getAbsolutePath());
            return;
        }
        String packedName = jarfile.getAbsolutePath() + ".pack.gz";
        File dest = new File(packedName);
        try {
            ByteArrayOutputStream packedResultStream = new ByteArrayOutputStream();
            FileInputStream fis = new FileInputStream(jarfile);
            Pack200Impl.pack(fis, packedResultStream, null);
            fis.close();
            byte[] packedResult = packedResultStream.toByteArray();
            ByteArrayOutputStream zippedResultStream = new ByteArrayOutputStream();
            Tools.gzip(new ByteArrayInputStream(packedResult), zippedResultStream);
            byte[] zippedResult = zippedResultStream.toByteArray();
            Tools.writeArrayToFile(dest, zippedResult);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void unpack(InputStream is, OutputStream os) throws IOException {
        if (!Pack200Impl.hasPack200()) {
            System.err.println(PACK_CLASS + " not found, Pack200 features not available.");
            return;
        }
        Pack200.Unpacker unpack = Pack200.newUnpacker();
        JarOutputStream jos = new JarOutputStream(os);
        unpack.unpack(is, jos);
        is.close();
        jos.close();
    }

    public static void normalize(InputStream is, OutputStream os) throws IOException {
        ByteArrayOutputStream packed = new ByteArrayOutputStream();
        Pack200Impl.pack(is, packed, null);
        Pack200Impl.unpack(new ByteArrayInputStream(packed.toByteArray()), os);
        os.close();
    }

    public static void normalize(File jarfile) {
        if (!jarfile.canRead()) {
            System.err.println("Cannot read file " + jarfile.getAbsolutePath());
            return;
        }
        if (!jarfile.canWrite()) {
            System.err.println("Cannot write file " + jarfile.getAbsolutePath());
            return;
        }
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            FileInputStream fis = new FileInputStream(jarfile);
            Pack200Impl.normalize(fis, result);
            fis.close();
            Tools.writeArrayToFile(jarfile, result.toByteArray());
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void packNormalized(InputStream is, OutputStream os, Map params) throws IOException {
        ByteArrayOutputStream unpacked = new ByteArrayOutputStream();
        Pack200Impl.normalize(is, unpacked);
        Pack200Impl.pack(new ByteArrayInputStream(unpacked.toByteArray()), os, params);
    }

    public static boolean hasPack200() {
        try {
            Class.forName(PACK_CLASS);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return true;
    }
}

