/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ListComboBoxModel
implements ComboBoxModel {
    private final List<? extends Object> elements;
    private final int maxIndex;
    private final boolean reverseOrder;
    private Object selectedItem;

    public ListComboBoxModel(List<? extends Object> list) {
        this(list, false);
    }

    public ListComboBoxModel(List<? extends Object> list, boolean bl) {
        if (list == null) {
            throw new IllegalArgumentException("the list of elements must not be null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("empty list of elements is not allowed");
        }
        this.elements = list;
        this.maxIndex = list.size() - 1;
        this.reverseOrder = bl;
    }

    @Override
    public void setSelectedItem(Object object) {
        this.selectedItem = object;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return this.maxIndex + 1;
    }

    @Override
    public Object getElementAt(int n) {
        return this.elements.get(this.reverseOrder ? this.maxIndex - n : n);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
    }
}

