/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons;

import com.jaspersoft.ireport.addons.background.BackgroundImageUtilities;
import com.jaspersoft.ireport.addons.callouts.CalloutsUtility;
import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.JrxmlEditorSupport;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ReportDesignerPanel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ReportOpenedListener
implements PropertyChangeListener {
    List<String> openedFiles = new ArrayList<String>();
    private static ReportOpenedListener mainInstance = null;

    private ReportOpenedListener() {
        WindowManager.getDefault().getRegistry().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        ReportOpenedListener.this.refreshDocumentsList();
                    }
                });
            }
        });
    }

    public void refreshDocumentsList() {
        JrxmlVisualView view;
        ArrayList<String> currentlyOpenedFiles = new ArrayList<String>();
        Set components = WindowManager.getDefault().getRegistry().getOpened();
        for (TopComponent t : components) {
            JrxmlEditorSupport jrxmlEditorSupport = (JrxmlEditorSupport)t.getLookup().lookup(JrxmlEditorSupport.class);
            if (jrxmlEditorSupport == null) continue;
            String fileName = FileUtil.toFile((FileObject)jrxmlEditorSupport.getDataObject().getPrimaryFile()).getPath();
            view = (JrxmlVisualView)jrxmlEditorSupport.getDescriptions()[0];
            if (view == null) continue;
            view.getReportDesignerPanel().removePropertyChangeListener((PropertyChangeListener)this);
            view.getReportDesignerPanel().addPropertyChangeListener((PropertyChangeListener)this);
            currentlyOpenedFiles.add(fileName);
        }
        ArrayList<String> closedFiles = new ArrayList<String>();
        for (String s : this.openedFiles) {
            if (currentlyOpenedFiles.contains(s)) continue;
            closedFiles.add(s);
        }
        for (String s : closedFiles) {
            this.openedFiles.remove(s);
        }
        for (String s : currentlyOpenedFiles) {
            JrxmlEditorSupport editorSupport;
            if (this.openedFiles.contains(s) || (editorSupport = this.getJrxmlEditorSupportForFile(new File(s))) == null || (view = (JrxmlVisualView)editorSupport.getDescriptions()[0]) == null) continue;
            this.propertyChange(new PropertyChangeEvent(view.getReportDesignerPanel(), "jasperdesign", editorSupport.getCurrentModel(), editorSupport.getCurrentModel()));
            this.openedFiles.add(s);
        }
    }

    public static void startListening() {
        ReportOpenedListener.getDefaultInstance();
    }

    public static ReportOpenedListener getDefaultInstance() {
        if (mainInstance == null) {
            mainInstance = new ReportOpenedListener();
        }
        return mainInstance;
    }

    public JrxmlEditorSupport getJrxmlEditorSupportForFile(File file) {
        Set components = WindowManager.getDefault().getRegistry().getOpened();
        for (TopComponent t : components) {
            File f;
            JrxmlEditorSupport jrxmlEditorSupport = (JrxmlEditorSupport)t.getLookup().lookup(JrxmlEditorSupport.class);
            if (jrxmlEditorSupport == null || jrxmlEditorSupport.getDataObject().getPrimaryFile() == null || !(f = FileUtil.toFile((FileObject)jrxmlEditorSupport.getDataObject().getPrimaryFile())).equals(file)) continue;
            return jrxmlEditorSupport;
        }
        return null;
    }

    public JrxmlVisualView getViewForJasperDesign(JasperDesign jd) {
        Set components = WindowManager.getDefault().getRegistry().getOpened();
        for (TopComponent t : components) {
            JrxmlEditorSupport jrxmlEditorSupport = (JrxmlEditorSupport)t.getLookup().lookup(JrxmlEditorSupport.class);
            if (jrxmlEditorSupport == null || jrxmlEditorSupport.getCurrentModel() != jd) continue;
            return (JrxmlVisualView)jrxmlEditorSupport.getDescriptions()[0];
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("jasperdesign")) {
            ReportDesignerPanel panel = (ReportDesignerPanel)evt.getSource();
            JasperDesign jd = panel.getJasperDesign();
            if (jd == null) {
                return;
            }
            JrxmlVisualView view = this.getViewForJasperDesign(jd);
            if (view != null) {
                try {
                    BackgroundImageUtilities.restore(view);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                try {
                    CalloutsUtility.loadCallouts((AbstractReportObjectScene)view.getReportDesignerPanel().getScene());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

