/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.ReportObjectPaletteTransferable;
import com.jaspersoft.ireport.designer.outline.nodes.ParameterNode;
import com.jaspersoft.ireport.designer.sheet.JRPropertiesMapProperty;
import com.jaspersoft.ireport.designer.sheet.properties.CrosstabParameterValueExpressionProperty;
import com.jaspersoft.ireport.designer.sheet.properties.DefaultValueExpressionProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class CrosstabParameterNode
extends ParameterNode
implements PropertyChangeListener {
    private JRDesignCrosstab crosstab = null;

    public CrosstabParameterNode(JasperDesign jd, JRDesignCrosstab crosstab, JRDesignCrosstabParameter parameter, Lookup doLkp) {
        super(jd, (JRDesignParameter)parameter, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{crosstab})}));
        this.crosstab = crosstab;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        set.put((Node.Property)new NameProperty(this.getParameter(), this.crosstab));
        set.put((Node.Property)new ParameterNode.ValueClassNameProperty(this, this.getParameter()));
        if (!this.getParameter().isSystemDefined()) {
            set.put((Node.Property)new CrosstabParameterValueExpressionProperty((JRDesignCrosstabParameter)this.getParameter(), ModelUtils.getElementDataset((JRDesignElement)this.crosstab, this.jd)));
            set.put((Node.Property)new DefaultValueExpressionProperty(this.getParameter(), ModelUtils.getElementDataset((JRDesignElement)this.crosstab, this.jd)));
            set.put((Node.Property)new ParameterNode.DescriptionProperty(this, this.getParameter()));
            set.put((Node.Property)new JRPropertiesMapProperty((JRPropertiesHolder)this.getParameter()));
        }
        sheet.put(set);
        return sheet;
    }

    public void destroy() throws IOException {
        if (!this.getParameter().isSystemDefined()) {
            this.crosstab.removeParameter((JRCrosstabParameter)this.getParameter());
            super.destroy();
        }
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        tras.put((ExTransferable.Single)new ReportObjectPaletteTransferable("com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldFromCrosstabParameterAction", this.getParameter()));
        return tras;
    }

    public void setName(String s) {
        if (s.equals("")) {
            throw new IllegalArgumentException("Parameter name not valid.");
        }
        List currentParameters = null;
        currentParameters = this.crosstab.getParametersList();
        for (JRDesignParameter p : currentParameters) {
            if (p == this.getParameter() || !p.getName().equals(s)) continue;
            throw new IllegalArgumentException("Parameter name already in use.");
        }
        String oldName = this.getParameter().getName();
        this.getParameter().setName(s);
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getParameter(), "Name", String.class, oldName, s);
        IReportManager.getInstance().addUndoableEdit(opue);
    }

    public static final class NameProperty
    extends PropertySupport.ReadWrite {
        JRDesignParameter parameter = null;
        JRDesignCrosstab crosstab = null;

        public NameProperty(JRDesignParameter parameter, JRDesignCrosstab crosstab) {
            super("name", String.class, "Name", "Name of the parameter");
            this.parameter = parameter;
            this.crosstab = crosstab;
            this.setValue("oneline", Boolean.TRUE);
        }

        public boolean canWrite() {
            return !this.getParameter().isSystemDefined();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getParameter().getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val.equals("")) {
                IllegalArgumentException iae = this.annotateException("Parameter name not valid.");
                throw iae;
            }
            String s = val + "";
            List currentParameters = null;
            currentParameters = this.crosstab.getParametersList();
            for (JRDesignParameter p : currentParameters) {
                if (p == this.getParameter() || !p.getName().equals(s)) continue;
                IllegalArgumentException iae = this.annotateException("Parameter name already in use.");
                throw iae;
            }
            String oldName = this.getParameter().getName();
            this.getParameter().setName(s);
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getParameter(), "Name", String.class, oldName, this.getParameter().getName());
            IReportManager.getInstance().addUndoableEdit(opue);
        }

        public JRDesignParameter getParameter() {
            return this.parameter;
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }
}

