/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.GroupingSet;
import mondrian.rolap.agg.Segment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupingSetsList {
    private final List<RolapStar.Column> rollupColumns;
    private final List<RolapStar.Column[]> groupingSetsColumns;
    private final boolean useGroupingSet;
    private final List<BitKey> rollupColumnsBitKeyList = new ArrayList<BitKey>();
    private final Map<Integer, Integer> columnIndexToGroupingIndexMap = new HashMap<Integer, Integer>();
    private final List<GroupingSet> groupingSets;

    public GroupingSetsList(List<GroupingSet> groupingSets) {
        this.groupingSets = groupingSets;
        boolean bl = this.useGroupingSet = groupingSets.size() > 1;
        if (this.useGroupingSet) {
            this.groupingSetsColumns = this.getGroupingColumnsList(groupingSets);
            this.rollupColumns = this.findRollupColumns();
            this.loadRollupIndex();
            this.loadGroupingColumnBitKeys();
        } else {
            this.groupingSetsColumns = new ArrayList<RolapStar.Column[]>();
            this.rollupColumns = new ArrayList<RolapStar.Column>();
        }
    }

    List<RolapStar.Column[]> getGroupingColumnsList(List<GroupingSet> groupingSets) {
        ArrayList<RolapStar.Column[]> groupingColumns = new ArrayList<RolapStar.Column[]>();
        for (GroupingSet aggBatchDetail : groupingSets) {
            groupingColumns.add(aggBatchDetail.getSegments()[0].aggregation.getColumns());
        }
        return groupingColumns;
    }

    public List<RolapStar.Column> getRollupColumns() {
        return this.rollupColumns;
    }

    public List<RolapStar.Column[]> getGroupingSetsColumns() {
        return this.groupingSetsColumns;
    }

    public List<BitKey> getRollupColumnsBitKeyList() {
        return this.rollupColumnsBitKeyList;
    }

    public BitKey getDetailedColumnsBitKey() {
        return this.rollupColumnsBitKeyList.get(0);
    }

    private void loadGroupingColumnBitKeys() {
        int bitKeyLength = this.getDefaultColumns().length;
        for (RolapStar.Column[] groupingSetColumns : this.groupingSetsColumns) {
            BitKey groupingColumnsBitKey = BitKey.Factory.makeBitKey(bitKeyLength);
            Set<RolapStar.Column> columns = this.convertToSet(groupingSetColumns);
            int bitPosition = 0;
            for (RolapStar.Column rollupColumn : this.rollupColumns) {
                if (!columns.contains(rollupColumn)) {
                    groupingColumnsBitKey.set(bitPosition);
                }
                ++bitPosition;
            }
            this.rollupColumnsBitKeyList.add(groupingColumnsBitKey);
        }
    }

    private void loadRollupIndex() {
        RolapStar.Column[] detailedColumns = this.getDefaultColumns();
        for (int columnIndex = 0; columnIndex < detailedColumns.length; ++columnIndex) {
            int rollupIndex = this.rollupColumns.indexOf(detailedColumns[columnIndex]);
            this.columnIndexToGroupingIndexMap.put(columnIndex, rollupIndex);
        }
    }

    private List<RolapStar.Column> findRollupColumns() {
        TreeSet<RolapStar.Column> rollupSet = new TreeSet<RolapStar.Column>(RolapStar.ColumnComparator.instance);
        for (RolapStar.Column[] groupingSetColumn : this.groupingSetsColumns) {
            Set<RolapStar.Column> summaryColumns = this.convertToSet(groupingSetColumn);
            for (RolapStar.Column column : this.getDefaultColumns()) {
                if (summaryColumns.contains(column)) continue;
                rollupSet.add(column);
            }
        }
        return new ArrayList<RolapStar.Column>(rollupSet);
    }

    private Set<RolapStar.Column> convertToSet(RolapStar.Column[] columns) {
        HashSet<RolapStar.Column> columnSet = new HashSet<RolapStar.Column>();
        for (RolapStar.Column column : columns) {
            columnSet.add(column);
        }
        return columnSet;
    }

    public boolean useGroupingSets() {
        return this.useGroupingSet;
    }

    public int findGroupingFunctionIndex(int columnIndex) {
        return this.columnIndexToGroupingIndexMap.get(columnIndex);
    }

    public Aggregation.Axis[] getDefaultAxes() {
        return this.getDefaultGroupingSet().getAxes();
    }

    protected GroupingSet getDefaultGroupingSet() {
        return this.groupingSets.get(0);
    }

    public RolapStar.Column[] getDefaultColumns() {
        return this.getDefaultGroupingSet().getSegments()[0].aggregation.getColumns();
    }

    public Segment[] getDefaultSegments() {
        return this.getDefaultGroupingSet().getSegments();
    }

    public BitKey getDefaultLevelBitKey() {
        return this.getDefaultGroupingSet().getLevelBitKey();
    }

    public BitKey getDefaultMeasureBitKey() {
        return this.getDefaultGroupingSet().getMeasureBitKey();
    }

    public RolapStar getStar() {
        return this.getDefaultSegments()[0].aggregation.getStar();
    }

    public List<GroupingSet> getGroupingSets() {
        return this.groupingSets;
    }

    public List<GroupingSet> getRollupGroupingSets() {
        ArrayList<GroupingSet> rollupGroupingSets = new ArrayList<GroupingSet>(this.groupingSets);
        rollupGroupingSets.remove(0);
        return rollupGroupingSets;
    }
}

