/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.guards;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.guards.GuardedSectionImpl;
import org.netbeans.modules.editor.guards.GuardedSectionsImpl;
import org.netbeans.modules.editor.guards.PositionBounds;

public final class InteriorSectionImpl
extends GuardedSectionImpl {
    private PositionBounds header;
    private PositionBounds body;
    private PositionBounds footer;

    InteriorSectionImpl(String string, PositionBounds positionBounds, PositionBounds positionBounds2, PositionBounds positionBounds3, GuardedSectionsImpl guardedSectionsImpl) {
        super(string, guardedSectionsImpl);
        this.header = positionBounds;
        this.body = positionBounds2;
        this.footer = positionBounds3;
    }

    public void setBody(String string) {
        this.setText(this.body, string, false);
    }

    public String getBody() {
        String string = null;
        if (this.isValid()) {
            try {
                string = this.body.getText();
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException(badLocationException);
            }
        }
        return string;
    }

    public void setHeader(String string) {
        this.setText(this.header, string, true);
    }

    public String getHeader() {
        String string = null;
        if (this.isValid()) {
            try {
                string = this.header.getText();
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException(badLocationException);
            }
        }
        return string;
    }

    public void setFooter(String string) {
        int n;
        boolean bl = string.endsWith("\n");
        int n2 = string.indexOf(10);
        if (n2 != (n = string.lastIndexOf(10)) || bl && n2 != -1) {
            if (bl) {
                string = string.substring(0, string.length() - 1);
            }
            string = string.replace('\n', ' ');
        }
        this.setText(this.footer, string, true);
    }

    public String getFooter() {
        String string = null;
        if (this.isValid()) {
            try {
                string = this.footer.getText();
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException(badLocationException);
            }
        }
        return string;
    }

    public Position getCaretPosition() {
        return this.body.getBegin();
    }

    void markGuarded(StyledDocument styledDocument) {
        this.markGuarded(styledDocument, this.header, true);
        this.markGuarded(styledDocument, this.footer, true);
    }

    void unmarkGuarded(StyledDocument styledDocument) {
        this.markGuarded(styledDocument, this.header, false);
        this.markGuarded(styledDocument, this.footer, false);
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this.header.getText());
            stringBuffer.append(this.body.getText());
            stringBuffer.append(this.footer.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public boolean contains(Position position, boolean bl) {
        if (!bl) {
            return this.header.getBegin().getOffset() <= position.getOffset() && this.footer.getEnd().getOffset() >= position.getOffset();
        }
        if (this.header.getBegin().getOffset() <= position.getOffset() && this.header.getEnd().getOffset() >= position.getOffset()) {
            return true;
        }
        return this.footer.getBegin().getOffset() <= position.getOffset() && this.footer.getEnd().getOffset() >= position.getOffset();
    }

    public Position getStartPosition() {
        return this.header.getBegin();
    }

    public Position getEndPosition() {
        return this.footer.getEnd();
    }

    public Position getBodyStartPosition() {
        return this.body.getBegin();
    }

    public Position getBodyEndPosition() {
        return this.body.getEnd();
    }

    public void resolvePositions() throws BadLocationException {
        this.header.resolvePositions();
        this.body.resolvePositions();
        this.footer.resolvePositions();
    }

    public PositionBounds getHeaderBounds() {
        return this.header;
    }

    public PositionBounds getBodyBounds() {
        return this.body;
    }

    public PositionBounds getFooterBounds() {
        return this.footer;
    }
}

