/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.gecamed.core.gui.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import lu.tudor.santec.gecamed.core.gui.launcher.GECAMedLauchnerCommand;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class GECAMedLauncher {
    public static final String[] args = null;
    private static final String CONFIG_FILE = "config/GECAMedLaucherServer.conf";
    private static final String USER_CONFIG_FILE = "user.conf";
    private static Logger logger = Logger.getLogger(GECAMedLauncher.class.getName());
    private static final File LOGFILE = new File("GECAMedLauncher.log");
    private static Properties serverConfig = new Properties();
    private static HashMap<String, GECAMedLauchnerCommand> commands = new HashMap();

    public static void main(String[] args) {
        String javaPath;
        String serverNameGECAMed;
        String userpath;
        logger.info("Start GECAMedLaucher 1.5 :)");
        GECAMedLauncher.initLogger();
        GECAMedLauncher.loadConfig();
        GECAMedLauncher.initCommands();
        StringBuilder params = new StringBuilder();
        logger.info("Check if the parameters are correct.");
        if (args.length > 0) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String[] paramLine = param.split(":");
                if (!commands.containsKey(paramLine[0].toUpperCase())) {
                    logger.warn("Error: " + paramLine[0] + " is not a GECAMed Launcher Command!");
                    System.out.println("Please use one or a combination of the following:\n");
                    for (GECAMedLauchnerCommand command : commands.values()) {
                        System.out.println(String.valueOf(command.getDescription()) + "\n");
                    }
                    System.exit(1);
                }
                params.append(String.valueOf(param) + " ");
                ++n2;
            }
        }
        if ((userpath = (String)serverConfig.get("USER_PATH")) == null) {
            logger.info("USER_PATH not set.");
        }
        if (userpath != null) {
            String userConfigPath = String.valueOf(userpath) + USER_CONFIG_FILE;
            logger.info("try to load user.conf: " + userConfigPath);
            if (new File(userConfigPath).exists()) {
                try {
                    serverConfig.load(new FileInputStream(userConfigPath));
                    logger.info("Loaded User Config From: " + userConfigPath);
                }
                catch (Exception e) {
                    logger.error("Error: Can't load user config file: " + userConfigPath, e);
                    System.exit(1);
                }
            } else {
                logger.warn("File not exists: " + userConfigPath);
            }
        }
        GECAMedLauncher.printConf();
        String serverNameLocal = (String)serverConfig.get("SERVER_NAME_LOCAL");
        if (serverNameLocal == null) {
            logger.error("SERVER_NAME_LOCAL not set, in file config/GECAMedLaucherServer.conf!");
            System.exit(1);
        }
        int serverPort = Integer.parseInt((String)serverConfig.get("SERVER_PORT"));
        if ((String)serverConfig.get("SERVER_PORT") == null) {
            logger.error("SERVER_PORT not set, in file config/GECAMedLaucherServer.conf!");
            System.exit(1);
        }
        if ((serverNameGECAMed = (String)serverConfig.get("SERVER_NAME_GECAMED")) == null) {
            logger.warn("SERVER_NAME_GECAMED not set, in file config/GECAMedLaucherServer.conf!");
        }
        if ((javaPath = (String)serverConfig.get("JAVA_PATH")) == null) {
            logger.error("JAVA_PATH not set, in file config/GECAMedLaucherServer.conf!");
            System.exit(1);
        }
        if (serverNameGECAMed == null) {
            logger.error("SERVER_NAME_GECAMED not set, in file config/GECAMedLaucherServer.conf and not set in file user.conf!");
            System.exit(1);
        }
        logger.info("Try to open connection to gecamed ...");
        Socket socket = null;
        try {
            socket = new Socket(serverNameLocal, serverPort);
        }
        catch (UnknownHostException e1) {
            logger.info("waiting for startup GECAMed ...");
        }
        catch (IOException e1) {
            logger.info("waiting for startup GECAMed ...");
        }
        if (socket == null) {
            logger.info("try to start GECAMed ...");
            Process gecamedProcess = null;
            try {
                logger.info("Java path: " + javaPath);
                logger.info("try to start server @: " + javaPath + "javaws http://" + serverNameGECAMed + ":8080/gecamed/GECAMed.jnlp");
                gecamedProcess = Runtime.getRuntime().exec(String.valueOf(javaPath) + "javaws http://" + serverNameGECAMed + ":8080/gecamed/GECAMed.jnlp");
            }
            catch (IOException e) {
                logger.warn("Can't start GECAMed !!!");
                e.printStackTrace();
                System.exit(-1);
            }
            try {
                gecamedProcess.waitFor();
                logger.info("GECAMed starts ...");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            logger.info("Try to open connection to gecamed again ...");
            while (socket == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    logger.info("GECAMed Launcher can't sleep");
                }
                try {
                    socket = new Socket(serverNameLocal, serverPort);
                }
                catch (UnknownHostException e1) {
                    logger.info("waiting for startup GECAMed ...");
                }
                catch (IOException e1) {
                    logger.info("waiting for startup GECAMed ...");
                }
            }
        }
        logger.info("Send GECAMed the parameters");
        if (socket != null) {
            PrintWriter serverRequest = null;
            try {
                serverRequest = new PrintWriter(socket.getOutputStream(), true);
            }
            catch (IOException e) {
                logger.warn("Error: Server request not successfull!\n" + e.getStackTrace());
                e.printStackTrace();
            }
            if (args.length > 0) {
                serverRequest.println("execute=" + params.toString());
            } else {
                serverRequest.println("execute=");
            }
            InputStreamReader PortLeser = null;
            try {
                PortLeser = new InputStreamReader(socket.getInputStream());
            }
            catch (IOException e) {
                logger.warn("Error: GECAMedLauncherServer not answer!\n" + e.getStackTrace());
                e.printStackTrace();
            }
            BufferedReader Eingabe = new BufferedReader(PortLeser);
            try {
                if (Eingabe.readLine().equalsIgnoreCase("ok")) {
                    logger.info("Parameters are send.");
                } else {
                    logger.info("Error: Parameter sending. Server result: " + Eingabe.readLine());
                }
            }
            catch (IOException e) {
                logger.warn("Error: Can not read answer from server!\n" + e.getStackTrace());
                e.printStackTrace();
            }
        }
        logger.info("GECAMed successfully launched, GECAMedLauncher ende now ;)");
    }

    private static void printConf() {
        try {
            StringBuffer sb = new StringBuffer("Using Config:\n");
            for (Object key : serverConfig.keySet()) {
                sb.append("\t").append(key).append("=").append(serverConfig.get(key)).append("\n");
            }
            logger.info(sb.toString());
        }
        catch (Exception e) {
            logger.warn("Error printing Config", e);
        }
    }

    private static void loadConfig() {
        serverConfig.clear();
        try {
            serverConfig.load(new FileInputStream(CONFIG_FILE));
        }
        catch (Exception e) {
            logger.error("Error: Can't load config file: config/GECAMedLaucherServer.conf", e);
            System.exit(1);
        }
    }

    private static void initCommands() {
        commands.put("LOGIN", new GECAMedLauchnerCommand("LOGIN", "LOGIN:<username>:<userpasswort>"));
        commands.put("PATIENTSEARCH", new GECAMedLauchnerCommand("PATIENTSEARCH", "PATIENTSEARCH:<searchterm>"));
        commands.put("PATIENTMATRICULESEARCH", new GECAMedLauchnerCommand("PATIENTMATRICULESEARCH", "PATIENTMATRICULESEARCH:<socialsecuritynumber>"));
        commands.put("GOTOMODULE", new GECAMedLauchnerCommand("GOTOMODULE", "GOTOMODULE:<modulname>"));
        commands.put("OPENPATIENTBYID", new GECAMedLauchnerCommand("OPENPATIENTBYID", "OPENPATIENTBYID:<gecamedpatientid>"));
        commands.put("OPENPATIENTBYNAME", new GECAMedLauchnerCommand("OPENPATIENTBYNAME", "OPENPATIENTBYNAME:<patientname"));
        commands.put("OPENPATIENTBYMATRICULE", new GECAMedLauchnerCommand("OPENPATIENTBYMATRICULE", "OPENPATIENTBYMATRICULE:<socialsecuritynumber>"));
        commands.put("OPENPATIENTBYKIS", new GECAMedLauchnerCommand("OPENPATIENTBYKIS", "OPENPATIENTBYKIS:<kisid>"));
    }

    private static void initLogger() {
        try {
            Logger.getRootLogger().removeAllAppenders();
            PatternLayout layout = new PatternLayout("%d{yyyy-MM-dd hh:mm:ss,SSS} %c %M (line %L)%n%p: %m%n");
            Logger.getRootLogger().addAppender(new ConsoleAppender(layout));
            RollingFileAppender fileAppender = new RollingFileAppender(layout, LOGFILE.getAbsolutePath(), true);
            fileAppender.setMaxFileSize("5MB");
            fileAppender.setMaxBackupIndex(3);
            fileAppender.setEncoding("UTF-8");
            BasicConfigurator.configure(fileAppender);
            Logger.getRootLogger().setLevel(Level.INFO);
        }
        catch (Exception e) {
            logger.log(Level.ERROR, "Error initializing Logger", e);
            System.err.println("Error initializing Logger");
            e.printStackTrace();
        }
    }
}

