/* ********************************************************************** */
/*                            UPDATE db_update_2.07.00_005.sql            */
/* ---------------------------------------------------------------------- */

-- delete all manual added labo rates from 01/2017 and update them via this script.
DELETE FROM billing.rate where key_type = 2 AND applicability = '2017-01-01' AND id NOT IN (SELECT DISTINCT rate_id FROM billing.template_rates);

-- UPDATED RATES
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2009, 'LC006', E'Hb A 1 c, hémoglobine glyquée ', '2017-01-01', 26.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2009, 'LC019', E'Lp (a) - Lipoprotéine (a) ', '2017-01-01', 24.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2010, 'LC027', E'Immunoélectrophorèse des protéines et protéines totales (non cumulable à LC026) ', '2017-01-01', 33.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2010, 'LC033', E'IgA - immunoglobulines A ', '2017-01-01', 24.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2010, 'LC034', E'IgM - immunoglobulines M ', '2017-01-01', 24.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2010, 'LC035', E'IgG - immunoglobulines G ', '2017-01-01', 24.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2010, 'LC042', E'CRP - Protéine C réactive, dosage ', '2017-01-01', 22.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2010, 'LC055', E'Myoglobine ', '2017-01-01', 40.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2010, 'LC056', E'Troponine T ou I ', '2017-01-01', 40.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2010, 'LC060', E'Homocystéine ', '2017-01-01', 55.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2011, 'LC071', E'AFP, alpha-foetoprotéine ', '2017-01-01', 40.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2011, 'LC072', E'CEA, antigène carcino-embryonnaire ', '2017-01-01', 40.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2011, 'LC073', E'CA 15-3, carcinoma antigen 15-3 ', '2017-01-01', 44.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2011, 'LC074', E'CA 19-9, carcinoma antigen 19-9 ', '2017-01-01', 44.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2011, 'LC076', E'CA 125, carcinoma antigen 125 ', '2017-01-01', 44.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2011, 'LC079', E'PSA total, prostatic specific antigen ', '2017-01-01', 38.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2011, 'LC080', E'PSA libre (mise en compte limitée au diagnostic différentiel cancer/hypertrophie bénigne, si PSA total entre 4 et 10 ng/ml) ', '2017-01-01', 23.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2013, 'LC133', E'Ferritine ', '2017-01-01', 22.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2013, 'LC134', E'Transferrine (Tf) et/ou capacité de fixation de la transferrine (IBC) ', '2017-01-01', 23.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2014, 'LC174', E'Lipase ', '2017-01-01', 24.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2014, 'LC176', E'CHE - cholinestérase ', '2017-01-01', 24.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2015, 'LC191', E'Vitamine B 12, cyanocobalamine ', '2017-01-01', 36.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2015, 'LC192', E'Acide folique ', '2017-01-01', 38.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2019, 'LC262', E'Microalbumine, dosage immunochimique, à remplacer par LC261, si recherche qualitative de protéines par bandelette positive ', '2017-01-01', 23.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2024, 'LD001', E'TSH, Thyréostimuline ', '2017-01-01', 25.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2024, 'LD003', E'FT4 - thyroxine libre ', '2017-01-01', 25.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2024, 'LD005', E'FT3 - triiodothyronine libre ', '2017-01-01', 38.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2024, 'LD007', E'Thyréoglobuline ', '2017-01-01', 50.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2025, 'LD101', E'PTH - Parathormone intacte ', '2017-01-01', 50.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2025, 'LD104', E'25 - OH-Vitamine D3 ', '2017-01-01', 53.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2026, 'LD201', E'Insuline ', '2017-01-01', 48.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2026, 'LD202', E'C-Peptide ', '2017-01-01', 48.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2027, 'LD302', E'Testostérone (non cumulable à LD301) ', '2017-01-01', 38.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2027, 'LD305', E'Déhydroépiandrostérone (DHEA) ou DHEA sulfate ', '2017-01-01', 48.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2027, 'LD306', E'TeBG (testosteron binding hormon) ou SHBG / SBP (sex hormon binding globulin/protein) ', '2017-01-01', 48.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2028, 'LD401', E'FSH - folliculostimuline ', '2017-01-01', 30.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2028, 'LD402', E'LH - lutéinostimuline ', '2017-01-01', 30.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2028, 'LD403', E'Prolactine ', '2017-01-01', 30.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2028, 'LD406', E'Oestradiol ', '2017-01-01', 45.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2028, 'LD412', E'Progestérone ', '2017-01-01', 45.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2028, 'LD415', E'(Bêta-) HCG - gonadotrophines chorioniques, dosage dans le sang ou dans les urines ', '2017-01-01', 37.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2029, 'LD502', E'Cortisol plasmatique ', '2017-01-01', 40.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2033, 'LE001', E'IgE - Immunoglobulines E totales ', '2017-01-01', 30.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2036, 'LE146', E'Autoanticorps antithyroperoxydase (anti-TPO) ', '2017-01-01', 41.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2036, 'LE147', E'Autoanticorps antithyroglobuline ', '2017-01-01', 41.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2048, 'LF101', E'Al - aluminium ', '2017-01-01', 80.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2048, 'LF102', E'Bi - bismuth ', '2017-01-01', 80.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2048, 'LF103', E'Cd - cadmium ', '2017-01-01', 80.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2048, 'LF104', E'Cr - chrome ', '2017-01-01', 80.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2048, 'LF105', E'Hg - mercure ', '2017-01-01', 80.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2048, 'LF106', E'Pb - plomb ', '2017-01-01', 80.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2048, 'LF107', E'Se - sélénium ', '2017-01-01', 80.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2048, 'LF108', E'Va - vanadium ', '2017-01-01', 80.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2048, 'LF109', E'Zn - zinc ', '2017-01-01', 45.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2048, 'LF115', E'Autre élément (As, S, Co, Mn, Ni, Te, Sn, cyanure...) ', '2017-01-01', 80.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2052, 'LG003', E'Hémogramme (NFS): hémoglobine, hématocrite, numération des érythrocytes, leucocytes et thrombocytes, avec formule leucocytaire, par un examen automatisé ', '2017-01-01', 23.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2052, 'LG004', E'Hémogramme complet : examen automatisé (voir LG003) et contrôle microscopique sur frottis pour anomalie signalée, avec formule sanguine relue au microscope, recherche ou confirmation d''anomalies sur une ou plusieurs lignées sanguines périphériques ', '2017-01-01', 29.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2054, 'LG221', E'Fibrinogène ', '2017-01-01', 34.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2054, 'LG253', E'D-dimère, dosage ', '2017-01-01', 47.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ010', E'Borrelia burgdorferi (mal. de Lyme), Ig ou IgG qualitatif ', '2017-01-01', 32.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ011', E'Borrelia burgdorferi IgM qualitatif ', '2017-01-01', 40.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ085', E'ASLO, antistreptolysine O (titre) ', '2017-01-01', 23.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2066, 'LJ312', E'Toxoplasma gondii, Ig ou IgG ', '2017-01-01', 30.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2066, 'LJ314', E'Toxoplasma: IgM ', '2017-01-01', 38.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ506', E'Cytomegalovirus (CMV), anticorps IgG ou Ig ', '2017-01-01', 36.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ508', E'Cytomegalovirus (CMV), anticorps IgM ', '2017-01-01', 36.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ521', E'Epstein-Barr virus (EBV) - VCA (capsid antigen), anticorps IgG ', '2017-01-01', 36.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ522', E'Epstein-Barr virus (EBV) - VCA, IgM ', '2017-01-01', 36.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ527', E'Epstein-Barr virus (EBV) - EBNA (nucleus antigen), anticorps Ig ou IgG ', '2017-01-01', 36.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ541', E'Hépatite A virus (HAV), Ig ou IgG qualitatif ', '2017-01-01', 33.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ543', E'Hépatite A virus (HAV), IgM ', '2017-01-01', 36.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ546', E'Hépatite B virus (HBV) HBs Ag , recherche ', '2017-01-01', 31.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ550', E'Hépatite B virus (HBV) Anti-HBc, anticorps Ig ', '2017-01-01', 32.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ553', E'Hépatite B virus (HBV) Anti-HBs ', '2017-01-01', 32.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ560', E'Hépatite C (HCV), anticorps Ig ou IgG ', '2017-01-01', 33.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ602', E'Human immunodeficiency virus (HIV) 1 + 2, dépistage des anticorps par EIA ', '2017-01-01', 32.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ672', E'Rubéole, virus, anticorps IgG, quantitatif ', '2017-01-01', 36.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ673', E'Rubéole, virus, anticorps IgM ', '2017-01-01', 36.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ682', E'Varicella Zoster, virus (VZV), anticorps Ig G quantitatif ', '2017-01-01', 37.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ684', E'Varicella Zoster, virus (VZV), anticorps IgM ', '2017-01-01', 37.00, false, false, false, false);
-- NEW RATES
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2005, 'LB051', E'Caryotype sur culture de cellules amniotiques', '2017-01-01', 650.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2005, 'LB052', E'Caryotype avec incubation sur villosités choriales, placenta ou sang foetal', '2017-01-01', 400.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2005, 'LB053', E'Dépistage prénatal 1er trimestre seul, par dosage de la (Bêta-)HCG libre et de la PAPP-A avec ou sans', '2017-01-01', 147.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2005, 'LB054', E'Dépistage prénatal 2e trimestre seul, par dosage combiné de la HCG, alpha-foetoprotéine et oestriol libre', '2017-01-01', 147.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2005, 'LB055', E'Dépistage prénatal combiné 1er et 2e trimestres, par dosage de la PAPP-A, HCG, alpha-foetoprotéine et', '2017-01-01', 188.00, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2010, 'LC062', E'Peptide natriurétique (BNP, NT-proBNP): Acte réservé exclusivement à la recherche d''une dyspnée aiguë pour', '2017-01-01', 72.00, false, false, false, false);
-- DELETED RATES
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2005, 'LB001', E'Caryotype sur culture de cellules amniotiques ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2005, 'LB002', E'Caryotype avec incubation sur villosités choriales, placenta ou sang foetal ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2009, 'LC024', E'(Bloc comprenant: LC014, LC013, LC012, non cumulable à LC017.) ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2009, 'LC025', E'(Bloc comprenant: LC017, LC018, non cumulable à LC024. ) ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2010, 'LC068', E'Immunoélectrophorèse des protéines et protéines totales - Immunofixation ou électrophorèse capillaire à l''aide d''au moins 5 antisérums pour recherche ou typage d''une dysglobulinémie monoclonale. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2010, 'LC069', E'Bloc immunoglobulines : IgA - IgM - IgG. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2011, 'LC099', E'PSA total - PSA libre. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2012, 'LC124', E'Bilan rénal de base : Créatinine, et urée. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2013, 'LC149', E'Ionogramme sérique de base : K et Na ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2014, 'LC188', E'CK créatinine kinase - Troponine T ou I .- ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2014, 'LC189', E'Bilan hépatique de base: ASAT = GOT - ALAT = GPT ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2015, 'LC199', E'Bilan vitamine B12 et acide folique : Vitamine B 12, cyanocobalamine et acide folique. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2017, 'LC209', E'Analyse d''urines avec sédiment: recherche de glucose, acétone, protéines, urobiline, bilirubine, sang, leucocytes, nitrites; détermination du pH et de la densité; examen du sédiment sous microscope - Urines, (ou: sonde, biopsie ... des voies urinaires) uroculture: examen microscopique, culture, numération et isolement des germes. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2018, 'LC259', E'« Ionogramme » urinaire : K et Na. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2024, 'LD098', E'TSH - FT4. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2024, 'LD099', E'TSH - FT4 - FT3. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2028, 'LD428', E'Prolactine - Macroprolactine. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2028, 'LD429', E'Bloc hormones hypophysaires : FSH - LH. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2035, 'LE134', E'Autoanticorps (facteurs) antinucléaires (AAN/ FAN), recherche par IF sur cellules HEp-2, avec titrage et description de l''aspect des AAN - Autoanticorps anti-ADN natif (nADN), titrage - Anticorps antinucléosome - Anticorps antihistones, recherche. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2035, 'LE135', E'Autoanticorps (facteurs) antinucléaires (AAN/ FAN), recherche par IF sur cellules HEp-2, avec titrage et description de l''aspect des AAN - Anticorps antiantigènes nucléaires solubles SS-A , SS-B , Sm, n-RNP, Scl-70, JO-1 et autres, recherche et titrage, (l''ensemble). ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2035, 'LE136', E'Autoanticorps (facteurs) antinucléaires (AAN/ FAN), recherche par IF sur cellules HEp-2, avec titrage et description de l''aspect des AAN - Anticorps antiantigènes nucléaires solubles SS-A , SS-B , Sm, n-RNP, Scl-70, JO-1 et autres, recherche et titrage, (l''ensemble) - Autoanticorps antimitochondries, titrage et identification. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2035, 'LE137', E'Autoanticorps (facteurs) antinucléaires (AAN/ FAN), recherche par IF sur cellules HEp-2, avec titrage et description de l''aspect des AAN - Autoanticorps antiactine, titrage (si titre > 1/80 à l''examen LE164 ou LE165). ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2035, 'LE138', E'Autoanticorps (facteurs) antinucléaires (AAN/ FAN), recherche par IF sur cellules HEp-2, avec titrage et description de l''aspect des AAN - Autoanticorps anti-ADN natif (nADN), titrage - Anticorps antinucléosome - Anticorps antihistones, recherche - Anticorps antiantigènes nucléaires solubles SS-A , SS-B, Sm, n-RNP, Scl-70, JO-1 et autres, recherche et titrage, (l''ensemble). ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2035, 'LE139', E'Autoanticorps (facteurs) antinucléaires (AAN/ FAN), recherche par IF sur cellules HEp-2, avec titrage et description de l''aspect des AAN - Identification des cibles des autoanticorps antimembrane nucléaire; par anticorps, maximum deux (GP 210, LB58). ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2036, 'LE159', E'Autoanticorps anti-thyroïde : Autoanticorps antithyroperoxydase (anti-TPO) - Autoanticorps antithyroglobuline. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2037, 'LE196', E'Plusieurs anticorps antitissus sur coupe de tissus de rein, foie et estomac (LKM) - Autoanticorps anticellules pariétales de l''estomac - Autoanticorps antifacteur intrinsèque - ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2037, 'LE197', E'Plusieurs anticorps antitissus sur coupe de tissus de rein, foie et estomac (LKM) - Autoanticorps antimitochondries, titrage et identification - Autoanticorps antiprotéines solubles hépatiques (anti-SLA) ou anti-LC 1 (anti-FTCD) - Autoanticorps antiréticulum endoplasmique (LKM et/ou anticytosol) décelés par l''examen LE164, confirmation par immunodiffusion ou immunoenzymologie. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2037, 'LE198', E'Plusieurs anticorps antitissus sur coupe de tissus de rein, foie et estomac (LKM) - Autoanticorps antimitochondries, titrage et identification. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2037, 'LE199', E'Plusieurs anticorps antitissus sur coupe de tissus de rein, foie et estomac (LKM) - Autoanticorps antiactine, titrage (si titre > 1/80 à l''examen LE164 ou LE165). ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2052, 'LG097', E'Hémogramme (NFS): hémoglobine, hématocrite, numération des érythrocytes, leucocytes et thrombocytes, avec formule leucocytaire, par un examen automatisé - Récepteurs solubles de la transferrine. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2052, 'LG098', E'Hémogramme (NFS): hémoglobine, hématocrite, numération des érythrocytes, leucocytes et thrombocytes, avec formule leucocytaire, par un examen automatisé - Vitamine B 12, cyanocobalamine - Acide folique. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2052, 'LG099', E'Hémogramme complet : examen automatisé et contrôle microscopique sur frottis pour anomalie signalée, avec formule sanguine relue au microscope, recherche ou confirmation d''anomalies sur une ou plusieurs lignées sanguines périphériques - Epstein-Barr virus (EBV) (mononucléose infectieuse/ Pfeiffer), (Burkitt lymphom) (Paul-Bunnell) - (EBV) - VCA (capsid antigen), IgG - (EBV) - VCA, IgM - (EBV) - EBNA (nucleus antigen), Ig ou IgG. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2058, 'LH199', E'Urines, (ou: sonde, biopsie ... des voies urinaires) uroculture: examen microscopique, culture, numération et isolement des germes - Identification biochimique et ou immunologique de germes aérobies isolés par culture - Antibiogramme de germes aérobies, par germe pathogène. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ114', E'Borrelia burgdorferi (mal. de Lyme), Ig ou IgG qualitatif - Borrelia burgdorferi, Confirmation IgG par Western blot. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ115', E'Borrelia burgdorferi IgM qualitatif - Borrelia burgdorferi, Confirmation IgM par Western blot. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ116', E'Borrelia burgdorferi, Confirmation IgG par Western blot - TPHA (Tréponema pallidum hémagglutination). ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ117', E'Brucella, Ig qualitatif - Brucella, Ig quantitatif, confirmation. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ118', E'Helicobacter pylori, IgG quantitatif - Helicobacter pylori, IgG, test de confirmation par Western blot. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ119', E'Helicobacter pylori, IgA - Helicobacter pylori, IgA, test de confirmation par Western blot. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ120', E'Sérodiagnostic Borreliose : Borrelia burgdorferi (mal. de Lyme), Ig ou IgG qualitatif - Borrelia burgdorferi IgM qualitatif. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ121', E'Sérodiagnostic Chlamydia pneumoniae : Chlamydia pneumoniae IgG - Chlamydia pneumoniae, IgA. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ122', E'Sérodiagnostic Chlamydia trachomatis: Chlamydia trachom. IgG - Chlamydia trachomatis, IgA. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ123', E'Sérodiagnostic Helicobacter pylori : Helicobacter pylori, IgG quantitatif - Helicobacter pylori, IgA. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ124', E'Sérodiagnostic Mycoplasma pneumoniae : Mycoplasma pneumoniae, Ig ou IgG, quantitatif - Mycoplasma pneumoniae, IgM. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2064, 'LJ125', E'Sérodiagnostic syphilis : Treponema pallidum (syphilis), VDRL (cardiolipine) - TPHA (Tréponema pallidum hémagglutination). ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2065, 'LJ229', E'Sérodiagnostic Candida : Candida sp., IgG - Candida sp., IgM. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2066, 'LJ338', E'Toxoplasma gondii, Ig ou IgG - Toxoplasma: IgM - Toxoplasma: test d''avidité des IgG. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2066, 'LJ339', E'Sérodiagnostic Toxoplasmose : Toxoplasma gondii, Ig ou IgG - Toxoplasma: IgM. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ700', E'Sérodiagnostic Adénovirus : Adenovirus, anticorps IgA - Adenovirus, anticorps IgM. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ701', E'Cytomegalovirus (CMV), anticorps IgG ou Ig - (CMV), anticorps IgM - (CMV), test de confirmation des IgM. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ702', E'Sérodiagnostic CMV: Cytomegalovirus (CMV), anticorps IgG ou Ig - (CMV), anticorps IgM. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ703', E'Sérodiagnostic EBV : Epstein-Barr virus (EBV) (mononucléose infectieuse/ Pfeiffer), (Burkitt lymphom) (Paul-Bunnell) - (EBV) - VCA (capsid antigen), IgG - (EBV) - VCA, IgM - (EBV) - EBNA (nucleus antigen), Ig ou IgG. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ704', E'Sérodiagnostic hépatite A : Hépatite A virus (HAV), Ig ou IgG quantitatif - (HAV), IgM. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ705', E'Sérodiagnostic hépatite B : Hépatite B virus (HBV) HBs Ag , recherche - (HBV) Anti-HBc, Ig - (HBV) Anti-HBs. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ706', E'Hépatite B virus (HBV) HBs Ag , recherche - (HBV) HBs Ag, test de confirmation - (HBV) HBe Ag, recherche - (HBV)Anti HBc IgM quantitatif - (HBV) Anti-HBe. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ707', E'Hépatite B virus (HBV) HBs Ag , recherche - (HBV) Anti-HBc, anticorps Ig - (HBV) Anti-HBs - (HBV)Anti HBc IgM quantitatif - (HBV) Anti-HBe - (HBV), amplification génique avec hybridation, quantitatif. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ708', E'Hépatite C (HCV), anticorps Ig ou IgG - (HCV), anticorps, test de confirmation (immunoblot) - (HCV), amplification génique avec hybridation, qualitatif. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ709', E'Herpes simplex virus (HSV) type 1, anticorps IgG - (HSV) type 2, anticorps IgG (dosages séparés). ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ710', E'Human immunodeficiency virus (HIV) 1 + 2, dépistage des anticorps par EIA - (HIV) 1, test de confirmation et spécification des anticorps (Westernblot ou Immunoblot) - (HIV) 2, test de confirmation (Westernblot ou Immunoblot). ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ711', E'Sérodiagnostic oreillons : Oreillons, virus, anticorps IgG quantitatif - IgM. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ712', E'Sérodiagnostic Parvovirus B19 : Parvovirus B 19, anticorps IgG quantitatif - IgM. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ713', E'Sérodiagnostic Rougeole : Rougeole, virus, anticorps IgG, quantitatif - IgM. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ714', E'Rubéole, virus, anticorps IgM, test de confirmation - IgM. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ715', E'Sérodiagnostic Rubéole : Rubéole, virus, anticorps IgG, quantitatif - IgM. ', '2017-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (2, 2068, 'LJ716', E'Sérodiagnostic VZV : Varicella Zoster, virus (VZV), anticorps IgG quantitatif - (VZV), IgM. ', '2017-01-01', 0.0, false, false, false, false);


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO core.info (date, key, value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.07.00_005.sql');
