/* ********************************************************************** */
/*                            UPDATE db_update_2.05.03_002.sql                   */
/* ---------------------------------------------------------------------- */


-- drop unused constraint that causes update problems
 ALTER TABLE billing.account ADD COLUMN  obsolete BOOLEAN DEFAULT FALSE;
 

-- add tarif MR03
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (1, 51, 'MR03', E'Forfait pour la coordination des soins dans les cas de pathologies lourdes ou chroniques ou de soins de longue durée et pour le suivi régulier du contenu du dossier de soins partagé de la personne protégée atteinte d’au moins une pathologie chronique grave qualifiée d’affection de longue durée et dont la gravité et/ou le caractère chronique nécessitent un traitement prolongé ainsi qu’un besoin de coordination substantiel du fait de l’intervention de multiples prestataires de soins de santé', '2016-01-01', 21.71, false, false, false, false);
-- remove MR01/MR02
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (1, 51, 'MR01', E'Forfait pour la gestion du dossier de soins partagé (résumé patient) pour patient entre 18 et 69 ans', '2016-01-01', 0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (1, 51, 'MR02', E'Forfait pour la gestion du dossier de soins partagé (résumé patient) pour patient à partir de 70 ans ou atteint d''une patologie chronique grave', '2016-01-01', 0, false, false, false, false);


-- just to be sure that this fix has been done on all installations....
-- add printed, closure_date, insurance_id
DROP VIEW billing.invoice_stub;
CREATE VIEW billing.invoice_stub         (id, state, old_state, invoice_number, class_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, insurance_id, third_party_id, created, due, printed, closure_date, reminders, reminder_date, statement_id, settlement_id, settlement_date, amount, payment, deduction, balance) AS
	SELECT DISTINCT invoice.id, invoice.state, invoice.old_state, invoice.invoice_number, invoice.class_id, invoice.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, invoice.insurance_id, invoice.third_party_id, invoice.created, invoice.due, invoice.printed, invoice.closure_date, invoice.reminders, invoice.reminder_date, invoice.statement_id, invoice.settlement_id, invoice.settlement_date, invoice.amount, invoice.payment, invoice.deduction, invoice.balance
    FROM billing.invoice, patient.patient
    WHERE patient.id = invoice.patient_id;
    
-- add printed, closure_date, insurance_id
DROP VIEW billing.trashed_invoice_stub;
CREATE VIEW billing.trashed_invoice_stub (id, state, old_state, invoice_number, class_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, insurance_id, third_party_id, created, due, printed, closure_date, reminders, reminder_date, statement_id, settlement_id, settlement_date, amount, payment, deduction, balance, trasher_id, trashing_date) AS
 	SELECT DISTINCT trashed_invoice.id, trashed_invoice.state, trashed_invoice.old_state, trashed_invoice.invoice_number, trashed_invoice.class_id, trashed_invoice.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, trashed_invoice.insurance_id, trashed_invoice.third_party_id, trashed_invoice.created, trashed_invoice.due, trashed_invoice.printed, trashed_invoice.closure_date, trashed_invoice.reminders, trashed_invoice.reminder_date, trashed_invoice.statement_id, trashed_invoice.settlement_id, trashed_invoice.settlement_date, trashed_invoice.amount, trashed_invoice.payment, trashed_invoice.deduction, trashed_invoice.balance, trashed_invoice.trasher_id, trashed_invoice.trashing_date
	FROM billing.trashed_invoice, patient.patient
	WHERE patient.id = trashed_invoice.patient_id;	

-- fix physician address contraint and delete unused addresses
ALTER TABLE office.physician DROP CONSTRAINT fk_physician_address_physician_id;
ALTER TABLE office.physician ADD CONSTRAINT fk_physician_address_physician_id FOREIGN KEY (address_id) REFERENCES office.physician_address (id) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE CASCADE;
DELETE FROM office.physician_address pa WHERE NOT EXISTS (SELECT id FROM office.physician p WHERE p.address_id = pa.id);


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO core.info (date, key, value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.05.03_002.sql');

