/* ********************************************************************** */
/*                            UPDATE db_update_2.05.00_001.sql                   */
/* ---------------------------------------------------------------------- */

-- add default statement
ALTER TABLE patient.patient add column storage text;
ALTER TABLE patient.patient add column remarks text;

DROP VIEW patient.patient_stub;

CREATE OR REPLACE VIEW patient.patient_stub AS
SELECT patient.id, patient.social_security_number, patient.sur_name, patient.first_name, patient.maiden_name, patient.gender, patient.insurance_id, patient.id_luxembourg, patient.storage, 
	(TRIM (trailing E'\n' FROM 
		(SELECT concat(((((((((address.zip::text || ' '::text) || address.locality::text) || ' '::text) || address.streetnumber::text) || ', '::text) || address.streetname::text) || ' - '::text) || address.country::text) || E'\n'::text) 
		FROM patient.patient sub_p1
		LEFT JOIN patient.patient_address address ON sub_p1.id = address.patient_id 
		WHERE sub_p1.id = patient.id))) as address,
	(TRIM (trailing E'\n' FROM 
		(SELECT concat(((phone.type::text || ': '::text) || phone.number::text) || E'\n'::text)
		FROM patient.patient sub_p2
		LEFT JOIN patient.patient_phone phone ON sub_p2.id = phone.patient_id
		WHERE sub_p2.id = patient.id))) as phone, patient.doctor_id,
	patient.search
FROM patient.patient patient;

/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO core.info (date, key, value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.05.00_001.sql');
