/* ********************************************************************** */
/*                            UPDATE 2.02.00_002                          */
/* ---------------------------------------------------------------------- */

-- ------------------------------
-- Billing Key/Rate History changes
-- ------------------------------

-- add key_id to key_value to group different versions of the same key_value
ALTER TABLE billing.key_value
ADD COLUMN key_type INTEGER DEFAULT NULL;

-- copy old id to new key_id
UPDATE billing.key_value set key_type = id;

-- rename key_value_id to key_type
ALTER TABLE billing.rate RENAME COLUMN key_value_id TO key_type;

-- change contraints on billing.rate
ALTER TABLE billing.rate DROP CONSTRAINT IF EXISTS fk_rate_keyvalue;
ALTER TABLE billing.rate DROP CONSTRAINT IF EXISTS un_rate_code;      

-- transform all key-values by creating new entries containing the old value
--NO LONGER NEEDED 
--INSERT INTO billing.key_value (next_value, applicability, label, description, fraction_digits, protected, editable, key_type) SELECT current_value, date '2000-01-01',label,description,fraction_digits,protected,editable,key_type FROM billing.key_value;

-- rename and remove columns
ALTER TABLE billing.key_value RENAME COLUMN next_value TO value;
ALTER TABLE billing.key_value DROP COLUMN current_value;

-- insert keyvalue history
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (0,E'Non Conventioné',  1,'2005-01-01',2,'true','true');
-- INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (1,E'UCM Médecins', 4.0017,'2014-03-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (1,E'UCM Médecins', 3.9618,'2013-10-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (1,E'UCM Médecins', 3.8652,'2012-10-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (1,E'UCM Médecins', 3.7710,'2011-10-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (1,E'UCM Médecins', 3.6790,'2011-01-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (1,E'UCM Médecins', 3.6857,'2010-07-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (1,E'UCM Médecins', 3.5959,'2009-03-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (1,E'UCM Médecins', 3.5018,'2008-03-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (1,E'UCM Médecins', 3.4164,'2007-01-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (1,E'UCM Médecins', 3.3331,'2005-01-01',1,'true','true');
-- INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (2,E'UCM Laboratoires',0.3557,'2009-01-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (2,E'UCM Laboratoires', 0.4411,'2000-05-01',1,'true','true');
-- INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (3,E'UCM Dentistes', 4.5761,'2011-10-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (3,E'UCM Dentistes', 4.4645,'2011-01-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (3,E'UCM Dentistes', 4.4742,'2009-03-01',1,'true','true');
INSERT INTO billing.key_value (key_type, label, value,applicability,fraction_digits,editable,protected) VALUES (3,E'UCM Dentistes', 4.2652,'2005-01-01',1,'true','true');

-- transform all rates creating new entries containing the old value
ALTER TABLE billing.rate RENAME COLUMN new_coefficient TO coefficient;
INSERT INTO billing.rate (key_type,index_id,code,label,cat,cac,apcm,acm,applicability,coefficient) SELECT key_type,index_id,code,label,cat,cac,apcm,acm,date '2000-01-01',old_coefficient FROM billing.rate;
ALTER TABLE billing.rate DROP COLUMN old_coefficient;

-- add applicability to rate_index for future use
ALTER TABLE billing.rate_index
ADD COLUMN applicability DATE DEFAULT NULL;

-- add missing rates
INSERT INTO billing.rate (key_type,index_id,code,label,cat,cac,apcm,acm,applicability,coefficient) VALUES (1,23,'F43',E'Traitement stationnaire dans un établissement spécialisé de rééducation fonctionnelle et réadaptation, par jour d hospitalisation',false,false,false,false,'2009-03-01',9.97);
INSERT INTO billing.rate (key_type,index_id,code,label,cat,cac,apcm,acm,applicability,coefficient) VALUES (1,23,'F48',E'Traitement stationnaire dans un établissement spécialisé de réhabilitation psychiatrique, par jour d hospitalisation en soins normaux',false,false,false,false,'2009-03-01',10.57);
INSERT INTO billing.rate (key_type,index_id,code,label,cat,cac,apcm,acm,applicability,coefficient) VALUES (1,23,'F49',E'Traitement stationnaire dans un établissement spécialisé de réhabilitation psychiatrique, par jour d hospitalisation en unité fermée',false,false,false,false,'2009-03-01',13.11);


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO core.info (date, key, value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.02.00_002.sql');

