/* ********************************************************************** */
/*                            UPDATE 1.4.00_001                           */
/* ---------------------------------------------------------------------- */

-- --------------------
-- 	enlarge the luxembourg ID column, to prepare for eSante
-- --------------------

-- drop the patient stub, to create it later on 
DROP VIEW IF EXISTS patient.patient_stub;

-- add and modify database for eSante
ALTER TABLE patient.patient
ALTER COLUMN id_luxembourg TYPE VARCHAR;

-- add the luxembourg ID to the patient stub
CREATE OR REPLACE VIEW patient.patient_stub AS
SELECT patient.id, patient.social_security_number, patient.sur_name, patient.first_name, patient.maiden_name, patient.gender, patient.insurance_id, patient.id_luxembourg, 
	(TRIM (trailing E'\n' FROM 
		(SELECT concat(((((((((address.zip::text || ' '::text) || address.locality::text) || ' '::text) || address.streetnumber::text) || ', '::text) || address.streetname::text) || ' - '::text) || address.country::text) || E'\n'::text) 
		FROM patient.patient sub_p1
		LEFT JOIN patient.patient_address address ON sub_p1.id = address.patient_id 
		WHERE sub_p1.id = patient.id))) as address,
	(TRIM (trailing E'\n' FROM 
		(SELECT concat(((phone.type::text || ': '::text) || phone.number::text) || E'\n'::text)
		FROM patient.patient sub_p2
		LEFT JOIN patient.patient_phone phone ON sub_p2.id = phone.patient_id
		WHERE sub_p2.id = patient.id))) as phone, patient.doctor_id,
	patient.search
FROM patient.patient patient;


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.4.00_001.sql');
