/* ************************************************************************ */
/*                             UPDATE 1.2.05_003                            */
/* ------------------------------------------------------------------------ */

-- drop the labo view, as this will cause trouble
DROP VIEW IF EXISTS labo.result_stub;

-- CHANGE ALL VARCHRS TO TYPE TEXT ...

ALTER TABLE labo.analysis
ALTER COLUMN sub_title TYPE TEXT,
ALTER COLUMN code_internal TYPE TEXT,
ALTER COLUMN code_loinc TYPE TEXT,
ALTER COLUMN label_internal TYPE TEXT,
ALTER COLUMN label_loinc TYPE TEXT,
ALTER COLUMN value TYPE TEXT,
ALTER COLUMN unit TYPE TEXT,
ALTER COLUMN reference_value TYPE TEXT,
ALTER COLUMN previous_value TYPE TEXT;

ALTER TABLE labo.antibiogram
ALTER COLUMN title TYPE TEXT,
ALTER COLUMN unit TYPE TEXT;

ALTER TABLE labo.antibiotic
ALTER COLUMN name TYPE TEXT;

ALTER TABLE labo.culture
ALTER COLUMN name TYPE TEXT,
ALTER COLUMN concentration TYPE TEXT,
ALTER COLUMN unit TYPE TEXT;

ALTER TABLE labo.reaction
ALTER COLUMN interpretation TYPE TEXT,
ALTER COLUMN mic TYPE TEXT,
ALTER COLUMN unit TYPE TEXT;

ALTER TABLE labo.result
ALTER COLUMN reference TYPE TEXT,
ALTER COLUMN examination_status TYPE TEXT,
ALTER COLUMN result_status TYPE TEXT;

-- re-create the view
CREATE VIEW labo.result_stub (id, laboratory_id, laboratory_name, prescriber_id, patient_id, patient_first_name, patient_name, patient_ssn, result_number, prescription_date, specimen_date, examination_date, downloaded, reference, examination_status, result_status ) AS
    SELECT DISTINCT result.id, result.laboratory_id, laboratory.name, result.prescriber_id, result.patient_id, patient.first_name, patient.sur_name, patient.social_security_number, result.result_number, result.prescription_date, result.specimen_date, result.examination_date, result.downloaded, result.reference, result.examination_status, result.result_status
    FROM labo.result, labo.laboratory, patient.patient
    WHERE laboratory.id = result.laboratory_id AND patient.id = result.patient_id;


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.2.05_003.sql');