/* ********************************************************************** */
/*                            UPDATE db_update_2.08.00_002.sql            */
/* ---------------------------------------------------------------------- */

-- ADD STORAGE FIELD TO SEARCH STRING

-- create search update trigger function for updates
CREATE OR REPLACE FUNCTION patient.update_search_column_func ()
  RETURNS TRIGGER AS $$
BEGIN
  IF     not_equals(OLD.first_name, NEW.first_name)
      OR not_equals(OLD.sur_name, NEW.sur_name)
      OR not_equals(OLD.maiden_name, NEW.maiden_name)
      OR not_equals(OLD.social_security_number, NEW.social_security_number)
      OR not_equals(OLD.storage, NEW.storage)
  THEN
    UPDATE patient.patient
    SET search = ' '
      || UPPER(patient.unaccent(NEW.first_name)) || ' '
      || UPPER(patient.unaccent(NEW.sur_name))   || ' '
      || UPPER(patient.unaccent(NEW.maiden_name))|| ' '
      || UPPER(patient.unaccent(NEW.social_security_number))
      || CASE WHEN NEW.storage <> '' THEN ' !' || UPPER(patient.unaccent(NEW.storage)) ELSE '' END
    WHERE id = NEW.id;
  END IF;

  RETURN NEW;
END
$$ LANGUAGE plpgsql;

-- create search update trigger function
CREATE OR REPLACE FUNCTION patient.insert_search_column_func ()
  RETURNS TRIGGER AS $$
BEGIN
  UPDATE patient.patient
  SET search = ' '
    || UPPER(patient.unaccent(NEW.first_name)) || ' '
    || UPPER(patient.unaccent(NEW.sur_name))   || ' '
    || UPPER(patient.unaccent(NEW.maiden_name))|| ' '
    || UPPER(patient.unaccent(NEW.social_security_number))
    || CASE WHEN NEW.storage <> '' THEN ' !' || UPPER(patient.unaccent(NEW.storage)) ELSE '' END
  WHERE id = NEW.id;

  RETURN NEW;
END
$$ LANGUAGE plpgsql;

-- Update the entries for the existing patients.
UPDATE patient.patient
    SET search = ' '
      || UPPER(patient.unaccent(first_name)) || ' '
      || UPPER(patient.unaccent(sur_name))   || ' '
      || UPPER(patient.unaccent(maiden_name))|| ' '
      || UPPER(patient.unaccent(social_security_number))
      || CASE WHEN storage <> '' THEN ' !' || UPPER(patient.unaccent(storage)) ELSE '' END 
WHERE patient.patient.storage IS NOT NULL AND patient.patient.storage != '' ;



/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO core.info (date, key, value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.08.00_002.sql');
