/* ********************************************************************** */
/*                            UPDATE db_update_2.07.00_001.sql            */
/* ---------------------------------------------------------------------- */

-- add obsolete flag to accounts
ALTER TABLE billing.account DROP COLUMN IF EXISTS obsolete;
ALTER TABLE billing.account ADD COLUMN obsolete BOOLEAN DEFAULT FALSE;

-- drop foreign key to invoice 
ALTER TABLE billing.ledger DROP CONSTRAINT fk_ledger_invoice;

-- delete ledgers without invoice id
DELETE FROM billing.ledger WHERE invoice_id IS null;


-- =============================================
-- Restore function for missing ledger entries
-- =============================================

-- Add a column in the ledger to mark  the ledger entries  that 
-- will be added by this script (useful for undoing, see below).

create or replace function patch_ledger_column() returns void as
$$
begin
    if exists (
        select * from information_schema.columns
            where table_name='ledger'
            and column_name='added_by_script'
     )
    then
        raise notice 'added_by_script already exists';
    else
        ALTER TABLE billing.ledger ADD COLUMN added_by_script BOOLEAN;
    end if;
end;
$$ language plpgsql;
select patch_ledger_column();
drop function if exists patch_ledger_column();


-- Print statistics about missing ledger entries: 
-- \echo The following amounts (per year) are missing in the ledger:
SELECT date_part('year', i.settlement_date) as year, sum(i.payment) as yearly_amount 
FROM billing.invoice i
WHERE ((i.settlement_id IS NOT NULL) AND 
       (i.settlement_date IS NOT NULL) AND 
       (i.payment <> 0.0))
AND NOT EXISTS
(SELECT NULL FROM billing.ledger l
 WHERE l.invoice_id = i.id)
GROUP BY year 
ORDER by year ASC;

-- create the missing ledger entries, based on invoices with a payment,
-- but without a corresponding ledger entry.
INSERT INTO billing.ledger (
 invoice_id, 
 cashier_id,
 settlement_id,
 settlement_date, 
 transaction_date,
 debit,
 credit,
 added_by_script)
(SELECT i.id, 1, i.settlement_id, i.settlement_date, now(), 0.0, i.payment, TRUE 
 FROM billing.invoice i
 WHERE i.settlement_id IS NOT NULL 
 AND i.settlement_date IS NOT NULL 
 AND i.payment <> 0.0
 AND NOT EXISTS
 (SELECT NULL FROM billing.ledger l
  WHERE l.invoice_id = i.id));

-- to undo the above operation execute this line:
-- DELETE FROM billing.ledger WHERE  added_by_script = TRUE;

-- \echo Invoices for which missing ledger entries have been restored:
SELECT NULL AS "Invoices for which missing ledger entries have been restored";
SELECT i.id, i.created, i.amount, i.payment, i.settlement_date, i.balance
FROM billing.invoice i, billing.ledger l
WHERE l.added_by_script = TRUE
AND i.id = l.invoice_ID;

-- =============================================


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO core.info (date, key, value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.07.00_001.sql');

