/* ********************************************************************** */
/*                            UPDATE 1.6.00_003                           */
/* ---------------------------------------------------------------------- */

-- Remark for eSanté intermediate versions:
-- can be executed several times

-- Update the vaccination card form template
UPDATE formeditor.form_template
SET version = '1.0.3',
xml = E'<?xml version="1.0" encoding="UTF-8"?>
<form info="Form template of GECAMed 2.00.03 - This file is a template to create forms for GECAMed (GEstion de CAbinet Medicaux)." name="Carnet de Vaccination" version="1.0.3" subFormOnly="false">
  <description>Vaccination record according to Luxemburgish standards.

The most common vaccinations are listed and can be checked. More can be added as free text (supported by autocompletion).

A single form instance represents one vaccination entry. A summary table showing all vaccinations of the patient is displayed, too.</description>
  <layout>
    <colFormat>0px,f:0px:n,f:77px:n,f:71px:n,f:124px:n,f:110px:n,f:110px:n,f:92px:n,f:148px:n,fill:142px:none,fill:160px:none</colFormat>
    <rowFormat>0px,f:10px:n,f:30px:n,f:5px:n,f:50px:n,bottom:80px:n,fill:p:none,fill:30px:none,fill:50px:none,fill:p:none</rowFormat>
    <backgroundImg />
  </layout>
  <component xCoord="6" yCoord="6" xSize="1" ySize="1" key="polio" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="POLIO">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;POLIO (IPV)&lt;/b&gt;&lt;i&gt;&lt;br&gt;Kinderlähmung</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>fill</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="3" yCoord="9" xSize="9" ySize="1" key="label_1" value="Vue d''ensemble des vaccinations :" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>36</fontSize>
    <fontFamily>Georgia</fontFamily>
    <fontColor>true,102,102,255,255</fontColor>
    <hAlign>fill</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="3" yCoord="5" xSize="9" ySize="1" key="label_2" value="Vaccination :" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>36</fontSize>
    <fontFamily>Georgia</fontFamily>
    <fontColor>true,102,102,255,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="4" yCoord="6" xSize="1" ySize="1" key="tetanus" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="TE">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;TE&lt;/b&gt;&lt;i&gt;&lt;br&gt;Tétanos&lt;br&gt;Tetanus</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="6" yCoord="3" xSize="2" ySize="1" key="_physician" value="PHYSICIAN" storeInDB="true" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableTextField</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>true,255,255,255,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="3" yCoord="3" xSize="3" ySize="1" key="label_3" value="La vaccination effectuée par :" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>16</fontSize>
    <fontFamily>Arial</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="3" yCoord="7" xSize="1" ySize="1" key="label_4" value="Plus :" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,51,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,102,255</fontColor>
    <hAlign>center</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="4" yCoord="7" xSize="4" ySize="1" key="misc" value="" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="Plus : ">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableAutoCompletionTextArea</type>
    <script eventTypeId="11">
      <scriptCode>validateTabbedPane(event);</scriptCode>
    </script>
    <structure>vaccination</structure>
    <border>false,0,0,0,255</border>
    <background>true,255,255,255,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="8" yCoord="6" xSize="1" ySize="1" key="hepB" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="HEPATITE B">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;HEPATITE B&lt;/b&gt;&lt;i&gt;&lt;br&gt;Hepatitis B</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="10" yCoord="6" xSize="1" ySize="1" key="meningitis" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="Méningite">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;Méningite&lt;/b&gt;&lt;i&gt;&lt;br&gt;méningocoques C&lt;br&gt;Hirnhautentzündung</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="7" yCoord="6" xSize="1" ySize="1" key="influenzaB" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="HAEMOPHILUS">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;HAEMOPHILUS&lt;/b&gt;&lt;i&gt;&lt;br&gt;Influenzae B</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="11" yCoord="6" xSize="1" ySize="1" key="mmrv" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="MMRV / RORV">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;MMRV / RORV&lt;/b&gt;&lt;br&gt;  &lt;i&gt;ROUGEOLE / Masern&lt;br&gt;  OREILLONS / &lt;i&gt;Mumps&lt;br&gt;  RUBEOLE / Röteln&lt;br&gt;  VARICELLE / Varizellen</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="5" yCoord="6" xSize="1" ySize="1" key="whoopingCough" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="PER">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;PER&lt;/b&gt;&lt;i&gt;&lt;br&gt;Coqueluche&lt;br&gt;Keuchhusten&lt;br&gt;Whooping cough</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="9" yCoord="6" xSize="1" ySize="1" key="infections" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="Infections">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;Infections invasives à&lt;/b&gt;&lt;i&gt;&lt;br&gt;streptococcus pneumoniaeinvasive infectios</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="3" yCoord="10" xSize="9" ySize="1" key="dataTable" value="" storeInDB="false" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableDataTable</type>
    <script eventTypeId="13">
      <scriptCode>reloadTable();</scriptCode>
    </script>
    <structure>#&#xD;
#Wed May 28 07:43:01 CEST 2014&#xD;
column.ref.9=misc;Plus&#xD;
column.ref.8=mmrv;MMRV&#xD;
column.ref.7=meningitis;Méningtite&#xD;
column.ref.6=infections;Infections invasives&#xD;
column.ref.5=influenzaB;HAEMOPHILUS&#xD;
column.ref.4=polio;POLIO&#xD;
column.ref.3=whoopingCough;PER&#xD;
column.ref.2=tetanus;TE&#xD;
column.ref.1=diphteria;DI&#xD;
column.ref.0=\\#creationDate;Date de Vaccination&#xD;
column.ref.10=_physician;Vaccination effectuée par&#xD;
column.width=129;46;45;39;50;101;121;73;51;224;153;</structure>
    <border>true,7,38,108,255</border>
    <background>true,255,255,255,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>fill</hAlign>
    <vAlign>fill</vAlign>
  </component>
  <component xCoord="3" yCoord="6" xSize="1" ySize="1" key="diphteria" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="DI">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;DI&lt;/b&gt;&lt;i&gt;&lt;br&gt;Diphtérie&lt;br&gt;Diphteria</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <initScript>// imports
importClass(javax.swing.SwingConstants);

var iter;
var component;
var componentList 	= components.values();
var renderer 		= dataTable.getDefaultRenderer(new java.lang.String("").getClass());


// reload the table
reloadTable();


// set the text alignment of the checkboxes from centered (default) to top
for (iter = componentList.iterator(); iter.hasNext(); )
{
	component = iter.next();
	if (component instanceof javax.swing.JCheckBox)
	{
		component.setVerticalTextPosition(SwingConstants.TOP);
	}
}


// set the alignment for the columns
renderer.setColumnAlignment(0, SwingConstants.LEFT);
renderer.setColumnAlignment(1, SwingConstants.CENTER);
renderer.setColumnAlignment(2, SwingConstants.CENTER);
renderer.setColumnAlignment(3, SwingConstants.CENTER);
renderer.setColumnAlignment(4, SwingConstants.CENTER);
renderer.setColumnAlignment(5, SwingConstants.CENTER);
renderer.setColumnAlignment(6, SwingConstants.CENTER);
renderer.setColumnAlignment(7, SwingConstants.CENTER);
renderer.setColumnAlignment(8, SwingConstants.CENTER);
renderer.setColumnAlignment(9, SwingConstants.LEFT);
renderer.setColumnAlignment(10,SwingConstants.LEFT);

// set the alignment for the rows
renderer.setRowAlignment(0, SwingConstants.TOP);
renderer.setRowAlignment(1, SwingConstants.TOP);
renderer.setRowAlignment(2, SwingConstants.TOP);
renderer.setRowAlignment(3, SwingConstants.TOP);
renderer.setRowAlignment(4, SwingConstants.TOP);
renderer.setRowAlignment(5, SwingConstants.TOP);
renderer.setRowAlignment(6, SwingConstants.TOP);
renderer.setRowAlignment(7, SwingConstants.TOP);
renderer.setRowAlignment(8, SwingConstants.TOP);
renderer.setRowAlignment(9, SwingConstants.TOP);
renderer.setRowAlignment(10,SwingConstants.TOP);</initScript>
  <function name="validateTabbedPane">
    <scriptCode>/**
 * This is supposed to validate the whole tab, containing the form,
 * everytime The enter-, delete-, or backspace-key was hit.
 * This is to enlarge the misc text area (respectively the row which
 * contains it), as there might be added a new line or an old line removed.
 */
function validateTabbedPane (event) 
{
	var keyCode = event.getKeyCode();
	var tab;
	
	if (keyCode == java.awt.event.KeyEvent.VK_ENTER
			|| keyCode == java.awt.event.KeyEvent.VK_DELETE
			|| keyCode == java.awt.event.KeyEvent.VK_BACK_SPACE)
	{
		tab = formContext.get("tab");
		
		if (tab == null)
		{
			// if this is the first time, tab is not in the context
			tab = mainPanel.getParent();
			while (tab.getParent() != null 
					&amp;&amp; !(tab instanceof javax.swing.JTabbedPane))
			{
				tab = tab.getParent();
			}
			globalContext.put("tab", tab);
		}

		// validate the tab with all its components
		tab.validate();
	}
}</scriptCode>
  </function>
  <function name="reloadTable">
    <scriptCode>/**
 * This function is supposed to configure the data table
 * after is has been loaded / reloaded. 
 * Mainly the "true" and "false" entries in the table are 
 * changed to "X" and empty string.
 */
function reloadTable ()
{
	var column;
	var row;
	var checkboxValue;
	var value;
	
	
	/* 
	 * Define the layout of the table by changing all "true" and "false"-Strings into 
	 * "X" or empty String and center them
	 */
	for (row = 0; row &lt; dataTable.getRowCount(); row++) 
	{
		for (column = 0; column &lt; dataTable.getColumnCount(); column++) 
		{
			value 			= dataTable.getValueAt(row, column);
			checkboxValue 	= false;
			
			if (value == null
					|| column == 0
					|| column == 10) 
				continue;
			
			if (column == 9)
			{
				/* make it a HTML-text and change the linebreaks 
				 * in the text into &lt;br/&gt;
				 */
				value = "&lt;html&gt;" + value.replace("\\n", "&lt;br/&gt;");
				dataTable.setValueAt(value, row, column);
			}
			else if (value.equals("true"))
			{
				// change the text from "true" to "X"
				dataTable.setValueAt("&lt;html&gt;&lt;p align=\\"center\\"&gt;X&lt;/p&gt;", row, column);
				checkboxValue = true;
			}
			else if (value.equals("false"))
			{
				// remove the text, if it is "false"
				dataTable.setValueAt("", row, column);
				checkboxValue = true;
			}
		}
	}
}</scriptCode>
  </function>
</form>'
WHERE name = 'Carnet de Vaccination';


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.6.00_003.sql');